set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7314629';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '31434044',
      '10211204',
      '42101102',
      '11011221',
      '10334112',
      '32340222',
      '43123334',
      '02101134',
      NULL,
      '34404342',
      '03134000',
      '40222014',
      '23143010',
      '04100344',
      '03020001',
      NULL,
      NULL,
      NULL,
      '03121040',
      '03413411',
      '44131332',
      '13134232',
      '11130312',
      '11132104',
      NULL,
      NULL,
      '31034210',
      '20031432',
      '21033312',
      '33310443',
      NULL,
      '41433014',
      '41341024',
      '00043121',
      '41140300',
      NULL,
      '21011242',
      NULL,
      NULL,
      NULL,
      '13224341',
      '14212413',
      NULL,
      '43010242',
      '114',
      NULL,
      29,
      3.505238,
      '3431223',
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      '11-10-1996',
      '11- 3-1991',
      89,
      18,
      NULL,
      NULL,
      22,
      15.394394,
      19.681748,
      NULL,
      18.210723,
      14.788552,
      2,
      7,
      26.673050,
      NULL,
      NULL,
      11.465502,
      9,
      1.186931,
      69,
      NULL,
      50.394733,
      27,
      NULL,
      1,
      NULL,
      75,
      NULL,
      15,
      85,
      130,
      77.059320,
      ' 7- 6-1984',
      64,
      16.299883,
      22,
      NULL,
      111.476391,
      239.454293,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      63,
      8.847601,
      3,
      23.176147,
      NULL,
      ' 2-26-1974',
      1,
      0.231955,
      45,
      NULL,
      0.002811,
      3.137132,
      NULL,
      0.664238,
      54.042957,
      NULL,
      NULL,
      NULL,
      ' 2-11-1993',
      48,
      65.865077,
      72,
      NULL,
      68,
      57,
      68,
      89.537404,
      43,
      94.246081,
      70.168693,
      NULL,
      ' 5-12-1989',
      35.431552,
      16.118682,
      39,
      6.399161,
      46.579089,
      190.191456,
      2.981052,
      ' 6- 9-1980',
      6.989953,
      10,
      ' 4-15-1998',
      1.173711,
      4,
      8.398793,
      5,
      8.358389,
      NULL,
      0.019588,
      3,
      1.422941,
      40,
      NULL,
      0.309517,
      NULL,
      NULL,
      3.434286,
      NULL,
      1.541717,
      0.550310,
      ' 6-28-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45,
      ' 7-14-2001',
      37,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      16,
      NULL,
      43.990093,
      NULL,
      44,
      NULL,
      NULL,
      86,
      ' 1-21-1983',
      2,
      32,
      14.145195,
      32.533269,
      ' 0-18-1989',
      26.641727,
      0,
      4.125013,
      ' 8-21-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


