set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6218579';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '01432130',
      '31324132',
      '33242001',
      '14144314',
      '31324140',
      '02012341',
      '43032433',
      NULL,
      NULL,
      NULL,
      '33104222',
      '03042122',
      '03002331',
      '12130214',
      NULL,
      '03124124',
      '31231214',
      '14212220',
      '24332341',
      NULL,
      '01344211',
      '10113033',
      '31311432',
      NULL,
      '03220003',
      '23033324',
      '02042124',
      '31140004',
      '40343443',
      '10000323',
      '32304341',
      '03423241',
      '31311322',
      '02032342',
      '13132301',
      NULL,
      '31422340',
      '40202101',
      '20303131',
      NULL,
      '33231423',
      '44002133',
      '04003344',
      '13112033',
      '034',
      '22',
      NULL,
      NULL,
      '4034004',
      2,
      0.101948,
      2,
      NULL,
      '222441',
      1.318936,
      ' 6-29-2003',
      '10-19-1999',
      95,
      NULL,
      26.472115,
      2.631041,
      15,
      8,
      16.880904,
      2,
      3.358219,
      5,
      22,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12,
      14.466452,
      15.641719,
      1.621024,
      NULL,
      21,
      23.445665,
      15,
      1.964667,
      78.364465,
      149.266117,
      48,
      99.234522,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.040346,
      NULL,
      1.744078,
      12.374849,
      1,
      6.381312,
      9,
      5,
      NULL,
      0,
      4.183151,
      1.402149,
      0,
      15.209105,
      1,
      0.589443,
      5,
      0.764492,
      1,
      4.323502,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      10,
      11,
      NULL,
      1.092219,
      ' 4-22-1989',
      NULL,
      NULL,
      67,
      NULL,
      1.239920,
      71.039610,
      1.613896,
      0,
      18,
      NULL,
      1.079699,
      5.924006,
      NULL,
      32,
      47,
      0.521381,
      8,
      31.327283,
      69.877786,
      29,
      28,
      80.765796,
      49,
      60.560874,
      35,
      ' 9-28-1999',
      5,
      0.093751,
      NULL,
      NULL,
      8.097523,
      1.915051,
      2,
      NULL,
      2,
      0.918240,
      ' 2- 5-1993',
      7,
      1,
      8,
      6,
      7.941874,
      NULL,
      NULL,
      NULL,
      0.571459,
      26,
      5.076999,
      0.517282,
      6.861887,
      17,
      6.887861,
      NULL,
      1.140210,
      1.947405,
      ' 9-16-1989',
      1,
      2.592540,
      3,
      ' 3- 9-1994',
      91.911149,
      142.222844,
      '11-18-1989',
      NULL,
      NULL,
      NULL,
      0,
      ' 3-15-1976',
      NULL,
      NULL,
      19.571828,
      6,
      ' 7-16-2000',
      NULL,
      NULL,
      NULL,
      1.224063,
      1,
      ' 8-18-1999',
      1,
      3,
      NULL,
      1,
      NULL,
      3,
      ' 7-29-1977',
      54,
      19.845610,
      11.992708,
      ' 8-13-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1);
commit;
end;
/


