set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6218579';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3101',
      '40014301',
      NULL,
      '33421413',
      NULL,
      NULL,
      '33223344',
      '32234411',
      '01202010',
      NULL,
      '03403000',
      '10342032',
      '22434144',
      '01304300',
      '11034114',
      '31333132',
      '13141343',
      '41102400',
      '30433300',
      '44043114',
      '00203431',
      '24230043',
      '20003104',
      '13434313',
      '02334210',
      '22320142',
      '20011144',
      '43023310',
      NULL,
      '22042443',
      NULL,
      '32421241',
      '04303303',
      '00142211',
      '31200030',
      '21431011',
      '12222313',
      '41234214',
      '12234044',
      '40231134',
      '01112424',
      '01114104',
      '13034222',
      '31211102',
      '21323011',
      '410',
      '30',
      NULL,
      NULL,
      '4024343',
      1.689015,
      24.248953,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 0-1979',
      '10-14-1998',
      140.437251,
      NULL,
      NULL,
      15.124539,
      0,
      8.396272,
      20,
      NULL,
      0,
      7,
      13,
      8,
      2.877919,
      21,
      16.980321,
      24.738907,
      NULL,
      NULL,
      24,
      NULL,
      3,
      10.494415,
      NULL,
      4.124803,
      1,
      16,
      NULL,
      NULL,
      175.033883,
      48,
      68.223107,
      NULL,
      12.621044,
      NULL,
      26,
      NULL,
      122,
      46,
      ' 6- 5-1975',
      NULL,
      18,
      4,
      NULL,
      6,
      12,
      NULL,
      NULL,
      NULL,
      1.824703,
      14.517028,
      0.589783,
      1.470186,
      3,
      0.869523,
      0,
      14.506512,
      2.781196,
      2,
      2.460415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      85,
      NULL,
      17,
      5.842680,
      21.880492,
      NULL,
      ' 4-20-2002',
      NULL,
      NULL,
      30.084237,
      NULL,
      0.613765,
      111,
      3.099780,
      NULL,
      46,
      NULL,
      NULL,
      NULL,
      ' 6-21-1985',
      NULL,
      41,
      14,
      0,
      14.040191,
      NULL,
      41.107380,
      NULL,
      NULL,
      33,
      69,
      63.955439,
      ' 5-20-1989',
      2,
      4.206805,
      11.229032,
      21,
      27.228289,
      0.258332,
      2,
      ' 1-29-1988',
      8.651266,
      3,
      ' 0-27-1983',
      0,
      2.239193,
      13,
      9.490342,
      NULL,
      4.619525,
      NULL,
      NULL,
      0,
      53,
      5.546160,
      NULL,
      0,
      NULL,
      3.668910,
      5,
      0.945184,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.867028,
      NULL,
      15,
      '11-28-1985',
      5,
      1.134144,
      ' 2- 8-1986',
      NULL,
      NULL,
      NULL,
      1.174893,
      3,
      '10-26-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      23.112070,
      ' 8-24-1987',
      5,
      0.614699,
      11,
      ' 0-15-1981',
      0,
      312,
      '11-16-1994',
      8.134750,
      63.362026,
      8.371514,
      NULL,
      NULL,
      13.256698,
      NULL,
      83.854199,
      ' 8-17-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


