set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3131',
      '20100022',
      '22043220',
      '42432220',
      NULL,
      '02434343',
      NULL,
      NULL,
      NULL,
      '02211340',
      '13124201',
      '01423030',
      '34423421',
      '23440223',
      NULL,
      '30122433',
      '42221434',
      '20403300',
      NULL,
      NULL,
      '12144102',
      '00131122',
      '32004430',
      '41242234',
      NULL,
      '01113242',
      '40140243',
      '40214120',
      '12223212',
      '11000412',
      NULL,
      '42102301',
      '42111102',
      '44222103',
      '00143333',
      NULL,
      '42440231',
      '03021400',
      '02340120',
      NULL,
      NULL,
      '01421234',
      '04423444',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '0334023',
      3,
      1,
      2,
      NULL,
      '204404',
      1,
      NULL,
      ' 0- 0-2001',
      NULL,
      NULL,
      25.791091,
      12,
      10.483885,
      17.371696,
      51.991612,
      8,
      14,
      7.861034,
      2.882687,
      5.949375,
      NULL,
      12,
      22.830549,
      10,
      6.084692,
      NULL,
      54.655337,
      16,
      29,
      3,
      57.498959,
      11.664612,
      NULL,
      91.855817,
      27,
      44,
      20.856912,
      62,
      9.682362,
      NULL,
      28.890756,
      16,
      21,
      9,
      18.771444,
      20,
      NULL,
      5,
      0,
      10.230017,
      1.042058,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.657098,
      1.363720,
      0.902782,
      1,
      0.376866,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-21-1974',
      28.183400,
      37,
      34.063265,
      52,
      32.448627,
      12.170216,
      95,
      NULL,
      33.143182,
      57,
      7,
      22.176104,
      ' 7- 4-1995',
      NULL,
      0.721755,
      5.252237,
      0.158836,
      30.094487,
      13,
      11,
      '11- 3-1993',
      2.761661,
      9.868538,
      NULL,
      9,
      7,
      1,
      12.906214,
      25.743159,
      8,
      NULL,
      8,
      NULL,
      NULL,
      13.735126,
      0,
      10.376646,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 0-19-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      34.448672,
      19.219960,
      NULL,
      2.792548,
      NULL,
      NULL,
      4.495755,
      204.070531,
      NULL,
      NULL,
      NULL,
      72.891752,
      0.138004,
      33.781035,
      ' 9-20-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      147.576856,
      2.844431,
      NULL,
      42,
      NULL,
      0.922482,
      NULL,
      0,
      0.073459,
      49.663566,
      3,
      1.215227,
      72,
      1,
      0.092690,
      66,
      1,
      0.828124,
      266,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.409051,
      NULL,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      1.900594,
      0,
      23.533390,
      0.805202,
      3.392409,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      19.835532,
      8,
      12.795862,
      NULL,
      NULL,
      15,
      NULL,
      7.045529,
      8,
      NULL,
      4,
      NULL,
      0.031238,
      0.191506,
      2,
      NULL,
      NULL,
      ' 1-21-1990',
      NULL,
      ' 9- 4-1982',
      ' 7-20-2001',
      '11-20-1998',
      NULL,
      NULL);
commit;
end;
/


