set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1412',
      '22440344',
      NULL,
      '14424314',
      NULL,
      NULL,
      '22440444',
      '01323430',
      '34320001',
      '10401103',
      '31430011',
      '40043144',
      '20303100',
      '30211003',
      '02340043',
      '12221114',
      '32422234',
      '42001131',
      '02234011',
      '20041040',
      '12212314',
      '30032104',
      '33412334',
      '11040212',
      '23434101',
      '01034023',
      '42312130',
      '13220012',
      NULL,
      '43120310',
      NULL,
      '21243434',
      '23313132',
      '00010430',
      '24324034',
      '23002402',
      NULL,
      '03021421',
      '01441242',
      NULL,
      '42431410',
      '24112032',
      '12101401',
      '12413103',
      '31312010',
      '314',
      '40',
      NULL,
      NULL,
      '2000432',
      0.387966,
      115.358561,
      2,
      NULL,
      '332444',
      NULL,
      ' 1- 5-1986',
      ' 2-17-1987',
      29.674507,
      NULL,
      29,
      15.690871,
      35,
      8.858086,
      12,
      2,
      16.300600,
      14,
      7.375922,
      NULL,
      31,
      0,
      7.317397,
      7,
      4.584079,
      5.169317,
      6.656977,
      11.678486,
      36.819796,
      NULL,
      14.497335,
      2,
      1.167035,
      69,
      130,
      20,
      NULL,
      135.471820,
      7,
      ' 5- 6-1984',
      NULL,
      14.212685,
      20.240791,
      2,
      48,
      72,
      ' 4- 1-1983',
      0.379160,
      NULL,
      1.828532,
      NULL,
      7.835634,
      NULL,
      8,
      NULL,
      0,
      1,
      0.749573,
      0.309322,
      1.822633,
      NULL,
      NULL,
      1.759339,
      0.782174,
      1.673752,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 2-22-1983',
      NULL,
      0,
      NULL,
      6,
      NULL,
      4,
      ' 2-14-1996',
      NULL,
      3.000733,
      88,
      NULL,
      0.812007,
      36,
      0,
      2,
      76.196054,
      0.918753,
      2,
      8.462499,
      ' 5-19-1978',
      84,
      NULL,
      64,
      NULL,
      62,
      60.130666,
      43.554437,
      35,
      54,
      20.087264,
      66,
      29.582320,
      ' 5- 1-1974',
      NULL,
      8.645855,
      25.642821,
      NULL,
      64,
      91.902150,
      10.573792,
      NULL,
      5,
      1.738003,
      NULL,
      NULL,
      1.061305,
      14.036379,
      13.656072,
      NULL,
      1,
      0.991914,
      6.808168,
      1,
      93,
      3,
      0,
      NULL,
      20.873022,
      2.360595,
      NULL,
      0.264926,
      NULL,
      ' 6-26-1981',
      NULL,
      1,
      2,
      ' 4-16-1982',
      117,
      NULL,
      ' 5-21-1986',
      NULL,
      NULL,
      NULL,
      2.717665,
      ' 3-14-2002',
      25.173335,
      NULL,
      6.381407,
      9,
      ' 3- 9-1983',
      79.751504,
      2,
      '11- 2-1982',
      NULL,
      NULL,
      ' 5- 3-1996',
      2,
      9,
      '11-27-1975',
      2,
      NULL,
      1,
      ' 8-25-1974',
      54.327064,
      NULL,
      20.001074,
      NULL,
      NULL,
      128.056516,
      ' 7-19-1986',
      0,
      24,
      23,
      NULL,
      ' 0-20-2001',
      39,
      0.028994,
      114.737363,
      ' 1-27-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


