set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8204649';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      '1',
      '1',
      '3',
      '4',
      '3',
      NULL,
      '4',
      '1',
      '0',
      '4',
      '4',
      '0',
      '2',
      '3',
      '1',
      '3',
      '0',
      '2',
      '0',
      '1',
      NULL,
      '1',
      '',
      NULL,
      '',
      '1',
      '0',
      NULL,
      '3',
      '4',
      '',
      '',
      '0',
      NULL,
      '1',
      '1',
      '0',
      '3',
      '1',
      '4',
      '3',
      NULL,
      '2',
      '030',
      '42422101',
      12.425120,
      40.825045,
      '1013100',
      NULL,
      311,
      0,
      NULL,
      '240301',
      2,
      ' 9-11-1984',
      '10-22-1990',
      55,
      179,
      NULL,
      8,
      7,
      13.766097,
      73.234743,
      8.154248,
      NULL,
      11.063954,
      5.396119,
      12.671885,
      13.891401,
      7.849643,
      2,
      NULL,
      7,
      13,
      15,
      18.359647,
      29.186088,
      6.705486,
      NULL,
      10.907987,
      0,
      NULL,
      113,
      65,
      33,
      13,
      NULL,
      '11-16-1986',
      31,
      35,
      30.704863,
      2,
      22.966553,
      87.510007,
      ' 7-19-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      6,
      7.691095,
      4.838490,
      NULL,
      0.308223,
      ' 4-24-2003',
      1,
      1,
      14.871687,
      NULL,
      NULL,
      89,
      NULL,
      0,
      57,
      NULL,
      NULL,
      NULL,
      ' 6- 1-1995',
      20.026478,
      19,
      NULL,
      28.085080,
      13,
      31,
      30,
      NULL,
      33,
      NULL,
      19,
      40.082374,
      '10-12-1987',
      1.829935,
      13.016479,
      13.231316,
      17,
      23,
      1,
      1,
      ' 6-12-1991',
      2,
      NULL,
      ' 6-10-1987',
      3,
      8.975178,
      9.987294,
      12,
      2.756911,
      5.412644,
      2,
      1.944266,
      0.906850,
      5.952564,
      NULL,
      1,
      0,
      18,
      8.234794,
      1.144049,
      0,
      1.713094,
      ' 5-22-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-24-1995',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-27-1987',
      13,
      ' 6-18-2000',
      9,
      11.677976,
      ' 6- 2-1992',
      92.958194,
      81,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      5,
      ' 0-16-1978',
      4.856775,
      NULL,
      15,
      ' 8- 1-1975',
      1.772268,
      192.831465,
      ' 8-22-1993',
      7.663729,
      37.118643,
      NULL,
      9,
      ' 6-20-1992',
      66.034025,
      0.500997,
      NULL,
      ' 9-14-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


