set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8328558';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2',
      '0',
      '4',
      '0',
      NULL,
      NULL,
      '0',
      '3',
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      NULL,
      '3',
      '1',
      '0',
      '4',
      NULL,
      '4',
      '1',
      '3',
      '',
      '1',
      '',
      '4',
      '1',
      '3',
      NULL,
      '2',
      '',
      '',
      '3',
      NULL,
      '0',
      '1',
      '3',
      '3',
      '4',
      '1',
      '0',
      '3',
      '2',
      '122',
      '21201302',
      21,
      NULL,
      '3200430',
      NULL,
      1,
      0,
      NULL,
      '343444',
      4,
      ' 5-17-1982',
      ' 0-26-2002',
      54,
      57,
      27,
      14.240715,
      18,
      15.660618,
      NULL,
      8.233285,
      13.213914,
      10,
      26.322236,
      7.978188,
      2,
      1.211170,
      NULL,
      6,
      0,
      6.735337,
      40.814942,
      19,
      19.712313,
      6.342237,
      79.987016,
      2,
      0,
      22,
      78.128076,
      50,
      NULL,
      59,
      NULL,
      ' 7-12-1981',
      33.403284,
      35,
      5.160060,
      21,
      1.149693,
      NULL,
      ' 1-24-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      42.888287,
      68,
      37,
      1.933389,
      0.805147,
      0.257576,
      '11-19-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19,
      7.752331,
      7.169849,
      4,
      0,
      8,
      8,
      3.419449,
      1.173141,
      10,
      9.082308,
      5.461674,
      ' 9- 6-1977',
      8,
      0.572341,
      4.746120,
      42.072195,
      17,
      42,
      9,
      NULL,
      NULL,
      16,
      ' 5-27-1995',
      NULL,
      NULL,
      8.823160,
      4.215395,
      1.328853,
      1.571864,
      1.914512,
      7.323542,
      1.488282,
      47,
      1.814899,
      0.627918,
      3.951971,
      23.749098,
      3,
      4.556799,
      1,
      0,
      ' 9-27-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      57,
      1.476534,
      ' 0-23-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      50,
      NULL,
      0,
      8.767364,
      ' 2-22-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      ' 0-21-1991',
      24,
      8.229962,
      3,
      ' 0- 3-1995',
      1.844842,
      278.359408,
      '10-27-1987',
      8.066858,
      24,
      16.280003,
      81,
      ' 3-15-1996',
      11,
      1.617781,
      149,
      '11-28-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


