set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8328558';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '4',
      '3',
      NULL,
      '3',
      NULL,
      '2',
      NULL,
      '1',
      '2',
      '0',
      '0',
      '4',
      '1',
      NULL,
      '4',
      '2',
      '4',
      '2',
      '0',
      '4',
      '3',
      NULL,
      '2',
      '',
      '1',
      '',
      NULL,
      '2',
      '3',
      '1',
      '2',
      NULL,
      '',
      '4',
      NULL,
      '4',
      NULL,
      NULL,
      '3',
      '4',
      '1',
      '0',
      '2',
      '1',
      '220',
      '44021303',
      19.899254,
      28.421070,
      '0341311',
      1.413993,
      20,
      0,
      0,
      '224220',
      1,
      ' 9-10-1992',
      '10-29-1975',
      NULL,
      30,
      NULL,
      NULL,
      23,
      20.029035,
      NULL,
      1,
      23,
      11,
      29,
      2.180674,
      7,
      NULL,
      11,
      13.142252,
      20,
      0.611329,
      44.709319,
      10,
      NULL,
      20.927643,
      139.516512,
      25.520377,
      NULL,
      95.333235,
      39.047589,
      NULL,
      57,
      143,
      177,
      NULL,
      NULL,
      5,
      18,
      22,
      NULL,
      183.112384,
      ' 0- 5-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      54,
      19,
      NULL,
      15.156884,
      3.652765,
      NULL,
      NULL,
      1,
      0.791330,
      132,
      0,
      NULL,
      143,
      NULL,
      0,
      88,
      NULL,
      NULL,
      NULL,
      ' 9-28-1990',
      106.644967,
      NULL,
      6.620706,
      18,
      7,
      18.445372,
      1.045996,
      NULL,
      5,
      NULL,
      34.193154,
      22,
      ' 7-23-1986',
      NULL,
      16.341728,
      8.709545,
      NULL,
      49.352097,
      68,
      4.180392,
      '11-20-2003',
      13.031380,
      1,
      '11- 7-1985',
      11,
      9.331816,
      18.442084,
      2.565616,
      NULL,
      NULL,
      0,
      10,
      1.472172,
      37.607075,
      1.351020,
      0,
      15.214216,
      10,
      NULL,
      1.615967,
      1,
      NULL,
      ' 6-28-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      124.343177,
      NULL,
      ' 1-12-1974',
      NULL,
      NULL,
      NULL,
      12,
      ' 3-11-1988',
      20.952856,
      NULL,
      14,
      5.402983,
      ' 5-14-1983',
      42.441149,
      49,
      ' 4-12-1986',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      20.715040,
      ' 1-13-1994',
      35.712581,
      1.259391,
      NULL,
      NULL,
      0.606644,
      NULL,
      ' 6-27-1995',
      16,
      35.938903,
      0.539790,
      9.790533,
      ' 5-24-2003',
      5.387282,
      1.239723,
      107,
      ' 2- 2-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


