set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9763254';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      '4',
      '4',
      NULL,
      '1',
      '4',
      '2',
      '2',
      '4',
      '3',
      '0',
      '4',
      '2',
      '2',
      NULL,
      '2',
      '0',
      '4',
      '2',
      NULL,
      '0',
      NULL,
      '0',
      '',
      '3',
      '',
      '1',
      '0',
      '1',
      NULL,
      '3',
      '',
      '',
      NULL,
      '1',
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      '4',
      '0',
      NULL,
      '0',
      '221',
      '24321403',
      14,
      25,
      '4120113',
      1,
      NULL,
      0,
      1,
      '010430',
      5,
      NULL,
      NULL,
      NULL,
      54.083574,
      NULL,
      20,
      21.125182,
      NULL,
      97,
      27.034992,
      16,
      21,
      15,
      14.864386,
      12,
      8.180976,
      27,
      NULL,
      NULL,
      8,
      63,
      25,
      13.122516,
      3,
      75,
      NULL,
      0.144998,
      162,
      55.909327,
      75,
      93.694950,
      25.203259,
      176,
      ' 8- 1-1993',
      35.248023,
      73,
      NULL,
      32,
      98.317084,
      154,
      ' 8-27-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15.007127,
      4,
      8,
      6.633455,
      11,
      2,
      ' 6- 0-1979',
      1.328820,
      1.695284,
      7.392181,
      NULL,
      1,
      NULL,
      1,
      1,
      62,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      12,
      68,
      77.758244,
      NULL,
      7.802911,
      13,
      NULL,
      87.547628,
      NULL,
      123,
      41.471553,
      '10- 0-1989',
      1.232716,
      27.134798,
      17.847290,
      30.753768,
      NULL,
      105,
      NULL,
      ' 6- 5-1995',
      NULL,
      1.094722,
      NULL,
      NULL,
      NULL,
      18,
      18.770855,
      NULL,
      16.722319,
      1.790492,
      3,
      NULL,
      117,
      0,
      0.648902,
      11,
      9,
      1,
      1,
      7,
      1.945089,
      ' 9-19-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      73,
      2,
      '11- 7-1998',
      NULL,
      NULL,
      NULL,
      8.768178,
      ' 2-22-2001',
      6.466869,
      ' 1- 8-1978',
      7,
      3.687741,
      ' 6-13-1992',
      43.551767,
      20.090338,
      ' 9-25-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      4,
      15,
      19.352455,
      NULL,
      1,
      83,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


