set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9676087';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '4',
      '4',
      '4',
      '2',
      NULL,
      '2',
      '0',
      '4',
      '3',
      NULL,
      '1',
      '0',
      '2',
      '1',
      '2',
      '4',
      '2',
      NULL,
      '0',
      NULL,
      '0',
      NULL,
      '3',
      '',
      '0',
      '',
      '1',
      '2',
      '4',
      NULL,
      '3',
      '',
      '',
      '3',
      '2',
      '3',
      '3',
      '3',
      '0',
      '2',
      '3',
      '4',
      '0',
      NULL,
      NULL,
      '34200402',
      60,
      NULL,
      '0421012',
      2.034604,
      1.769930,
      NULL,
      0,
      '312043',
      NULL,
      ' 4- 7-1989',
      ' 4-28-1975',
      87,
      219.637599,
      11.230652,
      5,
      15.193302,
      4,
      NULL,
      11,
      8.385844,
      6,
      NULL,
      6.662214,
      NULL,
      11.376014,
      NULL,
      1.224717,
      5,
      2,
      43,
      NULL,
      12,
      NULL,
      4,
      2.426736,
      NULL,
      74,
      114,
      25.310704,
      10.521278,
      153,
      111.303620,
      ' 0- 0-2000',
      51,
      20,
      30,
      NULL,
      132,
      173,
      ' 5-18-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40.720441,
      68,
      NULL,
      35,
      4,
      2,
      ' 4-20-1975',
      0,
      1,
      44,
      NULL,
      1.672406,
      28.481097,
      0,
      4.051282,
      14,
      NULL,
      NULL,
      NULL,
      '10- 7-1984',
      68,
      36,
      35,
      NULL,
      NULL,
      17.432715,
      84.782347,
      46.294150,
      29,
      73,
      NULL,
      71,
      ' 8- 5-2001',
      10.147252,
      13.241775,
      14,
      NULL,
      76,
      8,
      10.339960,
      ' 7- 2-1986',
      NULL,
      14.183514,
      '10- 0-1977',
      6.772192,
      1,
      3.258313,
      NULL,
      2.321133,
      NULL,
      3,
      0,
      3.365542,
      6,
      10,
      0,
      2,
      20.821599,
      0.247922,
      0,
      NULL,
      1.445695,
      '10- 6-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      33,
      0,
      '11- 5-1986',
      NULL,
      NULL,
      NULL,
      26,
      ' 7-16-2002',
      22,
      ' 8-28-1983',
      NULL,
      3.050366,
      ' 1- 7-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      18.298919,
      ' 0- 4-1996',
      44.780712,
      4,
      8.311157,
      ' 1- 3-1989',
      3.007390,
      172.123309,
      '10-25-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


