set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9750213';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      '2',
      NULL,
      '1',
      '1',
      NULL,
      '0',
      '0',
      '2',
      NULL,
      '4',
      '1',
      '4',
      '2',
      '2',
      '4',
      NULL,
      '1',
      '1',
      '4',
      '0',
      NULL,
      '4',
      NULL,
      '2',
      '',
      '0',
      '2',
      NULL,
      '0',
      '0',
      '',
      '',
      NULL,
      '3',
      '4',
      '1',
      NULL,
      '0',
      '3',
      NULL,
      '3',
      NULL,
      NULL,
      '300',
      '43434131',
      43,
      46,
      '1004200',
      3,
      25,
      1,
      1,
      '423043',
      4.607514,
      ' 4- 8-2002',
      NULL,
      65.691328,
      NULL,
      23,
      5,
      NULL,
      17.857669,
      7,
      NULL,
      4,
      NULL,
      2,
      NULL,
      NULL,
      21,
      18,
      NULL,
      8,
      4.224015,
      28.327921,
      19.608889,
      7.995210,
      7,
      47,
      12.785264,
      0,
      45.738123,
      72.669392,
      65.267467,
      64.271481,
      0,
      75.221310,
      ' 0-21-1991',
      19.396353,
      25,
      26.797947,
      7,
      NULL,
      189,
      '10-27-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      29.264201,
      5.465086,
      16,
      24,
      1,
      NULL,
      0,
      NULL,
      4.649890,
      1,
      0.087560,
      NULL,
      1,
      11.723199,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      91.314002,
      NULL,
      18,
      3,
      38,
      32,
      NULL,
      NULL,
      65,
      NULL,
      34.422287,
      64.904886,
      ' 8- 0-1994',
      1,
      11.090884,
      2,
      3.863117,
      NULL,
      1,
      2,
      NULL,
      16,
      13,
      ' 7-22-2002',
      4.480212,
      3,
      9.425110,
      NULL,
      20,
      7,
      1.176689,
      0.329276,
      0,
      52,
      0,
      NULL,
      1,
      29,
      0.734736,
      NULL,
      2.920409,
      1,
      ' 3-20-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      136.207353,
      66,
      NULL,
      NULL,
      NULL,
      NULL,
      40.663744,
      NULL,
      28.955856,
      ' 4-24-2000',
      12.550024,
      4.514894,
      ' 4- 3-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      2.557295,
      ' 5- 7-1993',
      NULL,
      11.259721,
      14.351633,
      ' 3-13-1996',
      NULL,
      135.364354,
      ' 8- 0-1991',
      5.930178,
      99.449269,
      NULL,
      NULL,
      ' 8-29-1974',
      NULL,
      0,
      140,
      ' 2- 1-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


