set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6607941';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      '42141102',
      NULL,
      '22324100',
      '32442300',
      '20411030',
      '31434012',
      '42333344',
      '22030424',
      '20124241',
      '10231414',
      NULL,
      '04300143',
      '34332420',
      '24201313',
      '22210120',
      '31222313',
      '12432414',
      '22341341',
      '14002021',
      NULL,
      NULL,
      '03243101',
      '23101003',
      '31430021',
      '00244343',
      '32142123',
      '31223102',
      NULL,
      '34314010',
      '12414032',
      '33411213',
      '33223200',
      '21001400',
      NULL,
      '22243432',
      '32344232',
      '02430204',
      '23200004',
      '10224024',
      '20341203',
      NULL,
      '13031241',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '0444442',
      2.853239,
      1,
      NULL,
      NULL,
      '033212',
      0.573509,
      ' 8- 0-1998',
      ' 9-28-1986',
      56.366559,
      NULL,
      NULL,
      18,
      5.300884,
      11.162512,
      66.536835,
      22.983029,
      NULL,
      4,
      29.104029,
      6,
      NULL,
      14.574938,
      8.603748,
      10.422220,
      NULL,
      7,
      42,
      10,
      55.303120,
      0.427587,
      32,
      NULL,
      NULL,
      18.520483,
      21,
      NULL,
      85.464452,
      NULL,
      172.451245,
      ' 8- 1-1989',
      NULL,
      NULL,
      36,
      NULL,
      NULL,
      NULL,
      '11- 3-1987',
      2.134649,
      NULL,
      NULL,
      23.607586,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.713771,
      25.117480,
      0.251397,
      NULL,
      34.811253,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-19-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-18-2003',
      4,
      107,
      77.024007,
      77.511529,
      38.223000,
      57.759429,
      63.114491,
      72.368625,
      NULL,
      NULL,
      53.339715,
      53,
      ' 7- 1-1989',
      13,
      11.015423,
      0,
      35.372974,
      62.933441,
      68,
      3.601760,
      ' 4-28-1984',
      25,
      1,
      ' 8- 6-1987',
      6.720121,
      8,
      5.406022,
      NULL,
      5,
      6,
      NULL,
      2.431342,
      NULL,
      NULL,
      11.497081,
      NULL,
      11.792119,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 5-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      57,
      6,
      3.055832,
      ' 0-16-1988',
      0.542556,
      NULL,
      ' 2- 5-1999',
      2,
      58,
      16.727249,
      NULL,
      ' 8-10-1997',
      36.882970,
      NULL,
      NULL,
      ' 7-22-1994',
      NULL,
      NULL,
      NULL,
      116,
      NULL,
      NULL,
      NULL,
      40,
      NULL,
      61,
      NULL,
      NULL,
      38,
      6,
      NULL,
      1.175858,
      0.816474,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.822287,
      3.761714,
      NULL,
      67,
      10,
      63,
      0,
      117,
      0,
      NULL,
      2.389345,
      20,
      0.325093,
      1.157043,
      33,
      61,
      115.446569,
      3.230316,
      NULL,
      20.507568,
      1,
      13,
      27.076158,
      NULL,
      5.959904,
      11,
      3,
      1,
      12.002933,
      1.080189,
      24,
      3.905562,
      0,
      34.515695,
      10,
      7.371473,
      21.114149,
      82.383977,
      32.660131,
      7.563580,
      103.411295,
      NULL,
      NULL,
      3.440024,
      6,
      5,
      0.331928,
      1,
      1.867304,
      11,
      NULL,
      ' 4- 6-1990',
      ' 4- 7-1975',
      ' 5-20-1986',
      ' 2-28-1976',
      ' 6-11-1983',
      ' 7-24-1974',
      NULL);
commit;
end;
/


