set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9646894';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '11221402',
      '32103220',
      '01313104',
      '22231242',
      '13042134',
      '44224413',
      '43430412',
      NULL,
      '44433144',
      '01112122',
      NULL,
      '30040312',
      '13122023',
      '43103432',
      '44112411',
      '34111424',
      '21400330',
      NULL,
      '41114442',
      '01233432',
      '04401013',
      '43111312',
      '12342224',
      '33214314',
      NULL,
      '41103414',
      '24131231',
      '40110031',
      '44010311',
      '04140200',
      '11013411',
      '03443303',
      '14034413',
      '44214443',
      '24221334',
      '21214402',
      '44222022',
      '34042042',
      '43330044',
      '13121203',
      '42144002',
      NULL,
      '24131130',
      '42344231',
      '410',
      '22',
      3.987334,
      NULL,
      '0420004',
      1,
      1,
      0,
      NULL,
      '232423',
      3.549842,
      ' 6- 6-1990',
      ' 0-10-1992',
      2.071622,
      22.994810,
      16.727309,
      18,
      9,
      NULL,
      21.799474,
      22,
      13.402274,
      0,
      32.689606,
      1,
      14.716881,
      17.432727,
      6,
      2.655681,
      26,
      0,
      45,
      17,
      36.657095,
      23.473522,
      97.866316,
      12.968715,
      NULL,
      NULL,
      51,
      58,
      191,
      127.024796,
      NULL,
      NULL,
      1,
      67.885025,
      NULL,
      NULL,
      137.560388,
      233.559510,
      ' 8-17-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      8,
      NULL,
      5,
      3,
      0.839547,
      ' 4- 6-2003',
      1.495363,
      NULL,
      46,
      0,
      2.312105,
      116.881806,
      1.301757,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 9-1989',
      28,
      4,
      68.013125,
      38,
      84,
      8.546134,
      75,
      75,
      21.815956,
      80,
      NULL,
      87.105317,
      '10- 4-1989',
      23.176106,
      33.598324,
      26.514208,
      19.498762,
      48,
      NULL,
      4.516470,
      NULL,
      1,
      11.398689,
      '11- 7-1998',
      0.897833,
      5.608233,
      5,
      16.293855,
      16,
      0.942661,
      1,
      8.611140,
      0,
      25.976398,
      0.764015,
      NULL,
      3.443154,
      NULL,
      0,
      NULL,
      1.208911,
      0.737149,
      ' 6-14-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      17,
      2.008162,
      '10-10-1988',
      NULL,
      NULL,
      NULL,
      41,
      ' 6- 3-1992',
      29,
      ' 9-14-1983',
      13,
      NULL,
      ' 0- 5-1981',
      64,
      96,
      '10-17-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      ' 7-19-1984',
      28,
      56,
      NULL,
      ' 3-11-1981',
      1,
      8.017753,
      ' 9-26-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


