set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8401071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4334',
      NULL,
      '04442102',
      '41113432',
      '10413210',
      '21202332',
      '01201403',
      '00011422',
      NULL,
      '22442033',
      NULL,
      '32034040',
      '22141321',
      '22001442',
      '14034100',
      '33442224',
      '34121224',
      '21232223',
      '21111203',
      '43024210',
      NULL,
      '02014013',
      '12101230',
      '04210132',
      '01140441',
      '31133223',
      NULL,
      '33414321',
      '24330031',
      '44013040',
      '44232323',
      '32124343',
      '41104104',
      NULL,
      '01224121',
      NULL,
      '02220440',
      '30112242',
      '03213001',
      '02021434',
      NULL,
      '31323344',
      '21231324',
      '02212144',
      NULL,
      '121',
      '14',
      34,
      21,
      NULL,
      1.571053,
      NULL,
      0,
      NULL,
      '324104',
      1.558868,
      ' 2-25-1985',
      '11- 6-1982',
      39,
      72.395536,
      13,
      21,
      14,
      5.828464,
      6,
      5,
      NULL,
      NULL,
      NULL,
      3,
      16.023128,
      3,
      3,
      NULL,
      8,
      15,
      NULL,
      17,
      29,
      10,
      3,
      5.727190,
      NULL,
      NULL,
      NULL,
      66.590531,
      28.995451,
      20,
      60.299181,
      NULL,
      5.260697,
      26.828529,
      26.850922,
      27.369797,
      54,
      98,
      ' 5- 9-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.685684,
      1.145420,
      NULL,
      21,
      4,
      ' 3-15-1990',
      1.426093,
      1,
      NULL,
      0.704198,
      0,
      NULL,
      1,
      1.815881,
      38,
      NULL,
      NULL,
      NULL,
      ' 8- 7-2002',
      29.206794,
      14,
      34.422781,
      6,
      37,
      0,
      17.286165,
      52,
      56.271261,
      70.424844,
      34.687247,
      18,
      ' 7-16-1998',
      4.695316,
      4,
      2.795942,
      16,
      17.988304,
      NULL,
      2.396540,
      ' 2- 6-2003',
      7.556413,
      4.189989,
      ' 8-22-1976',
      11,
      1,
      19,
      NULL,
      0,
      NULL,
      0,
      2.850594,
      NULL,
      66.001089,
      NULL,
      0.304282,
      0.978113,
      11.968120,
      1.298231,
      0,
      0,
      1,
      ' 3-25-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      17.115290,
      51.931416,
      ' 4-25-1980',
      NULL,
      NULL,
      NULL,
      35.502197,
      ' 0- 7-1980',
      19.627350,
      ' 0-16-1989',
      14.281643,
      10.736808,
      ' 0- 1-1995',
      6,
      124,
      ' 5- 2-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      40.866450,
      33.986719,
      42.447167,
      ' 4-20-1998',
      1.020463,
      45.553622,
      ' 6-19-1983',
      1,
      74.590226,
      10.080009,
      22.060603,
      ' 8-25-1975',
      4,
      1.178124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


