set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8401071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '3',
      NULL,
      '1',
      '1',
      NULL,
      NULL,
      '3',
      NULL,
      '3',
      '1',
      '4',
      '4',
      NULL,
      '4',
      '4',
      '2',
      '1',
      '3',
      NULL,
      '1',
      '0',
      '1',
      '3',
      '',
      '1',
      '',
      '1',
      NULL,
      '2',
      '3',
      NULL,
      '',
      '',
      '4',
      '2',
      '1',
      '0',
      '2',
      NULL,
      '3',
      '0',
      '1',
      '3',
      '2',
      '041',
      '21212321',
      36,
      10.505631,
      '2024234',
      1,
      4,
      0,
      NULL,
      NULL,
      2.605574,
      ' 9-19-1995',
      ' 5-19-1992',
      100.925980,
      158.450975,
      NULL,
      8,
      7.899984,
      5.159970,
      1,
      11,
      20,
      NULL,
      NULL,
      7,
      1,
      8,
      12.113177,
      6.580262,
      19.175717,
      12.174401,
      23,
      NULL,
      NULL,
      4,
      77.373092,
      0.500216,
      1.342021,
      37.767777,
      27.875979,
      14,
      73,
      164,
      104,
      ' 2- 7-1993',
      NULL,
      2.660211,
      3,
      24.344214,
      130.883777,
      32,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      28.801476,
      35,
      9,
      NULL,
      10.571781,
      7.513185,
      ' 6-21-1981',
      0.448176,
      0.347307,
      165.251974,
      1.467479,
      0,
      126.456343,
      1,
      6.150592,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-24-1988',
      31.692015,
      28,
      25.596407,
      6.622440,
      21,
      24,
      NULL,
      NULL,
      6,
      103.238954,
      NULL,
      11,
      NULL,
      NULL,
      7,
      10,
      8,
      2,
      8.382724,
      7,
      ' 0- 6-2002',
      17.145394,
      NULL,
      ' 8- 8-1975',
      12.785016,
      10,
      17.044023,
      0.217782,
      17.134696,
      1,
      0.830018,
      4.994808,
      0,
      40.391873,
      1,
      1.348893,
      9,
      23,
      NULL,
      NULL,
      1.474336,
      NULL,
      ' 3-19-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      164,
      31.822192,
      ' 3-14-1997',
      NULL,
      NULL,
      NULL,
      49.853259,
      ' 7-19-1974',
      31,
      ' 7-17-1976',
      NULL,
      2.192189,
      ' 0-27-1975',
      51,
      84,
      '11-24-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      53,
      29,
      4.102269,
      ' 4-20-1990',
      1,
      7.328743,
      ' 8-27-1997',
      2,
      NULL,
      0.150138,
      NULL,
      ' 8-27-1992',
      NULL,
      1,
      29,
      ' 9- 5-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


