set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8401071';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      '2',
      '2',
      '4',
      '3',
      '4',
      '1',
      '3',
      NULL,
      '0',
      '1',
      '4',
      '4',
      '4',
      NULL,
      '2',
      '1',
      '0',
      NULL,
      '1',
      '',
      '4',
      '1',
      '4',
      '3',
      NULL,
      '',
      '',
      '0',
      '4',
      NULL,
      '3',
      '0',
      '1',
      '3',
      '3',
      NULL,
      '1',
      '3',
      '102',
      '04330312',
      22.584957,
      71.805852,
      '2013204',
      3,
      NULL,
      3,
      1,
      '030033',
      2,
      ' 0-12-1997',
      ' 2- 3-1979',
      107,
      27.302641,
      NULL,
      NULL,
      15.025773,
      1,
      10,
      9.071387,
      14.948596,
      9,
      25,
      9,
      27.049374,
      5.365554,
      5.818067,
      10,
      NULL,
      NULL,
      3.013987,
      1.179266,
      NULL,
      15.171953,
      44.741843,
      7,
      0,
      22.272619,
      13,
      56,
      4.581177,
      12,
      NULL,
      ' 5- 5-1978',
      10.269296,
      27.884991,
      8.776677,
      27.708433,
      209,
      61.268574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      33.814286,
      36.127177,
      4.505880,
      3,
      2,
      2,
      NULL,
      1,
      1,
      77.272290,
      1.442600,
      0.556774,
      70,
      1,
      2.563831,
      21,
      NULL,
      NULL,
      NULL,
      ' 1-11-1992',
      11,
      52.926262,
      36,
      25.511733,
      32.801269,
      52.913828,
      56,
      66.787948,
      NULL,
      NULL,
      28,
      69,
      ' 7-12-2000',
      13,
      10,
      NULL,
      18.988921,
      50,
      NULL,
      2.422321,
      ' 7-17-1980',
      28,
      NULL,
      ' 5- 7-1976',
      3.645735,
      8,
      15.172853,
      NULL,
      1.964083,
      5.002068,
      NULL,
      10,
      0,
      3.055104,
      0.107257,
      1,
      13.050491,
      12,
      2.925633,
      1.770219,
      0,
      NULL,
      '10- 8-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      159.319050,
      22.842780,
      NULL,
      NULL,
      NULL,
      NULL,
      30.506961,
      '11-16-1997',
      29,
      ' 8- 4-2001',
      NULL,
      3,
      ' 8-21-2003',
      70.249295,
      107,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      18.729193,
      NULL,
      NULL,
      9,
      11.914018,
      ' 3-20-1992',
      1.953073,
      100,
      ' 8-24-1993',
      1,
      NULL,
      17.084103,
      25,
      ' 7- 7-1991',
      63.596656,
      NULL,
      72.124638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


