set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7624465';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1412',
      '03404014',
      '01043300',
      '00030403',
      '13000404',
      '12312002',
      '01201132',
      '11122034',
      NULL,
      NULL,
      '33414134',
      '10012310',
      NULL,
      '34014221',
      '14241302',
      '23013141',
      NULL,
      '11102330',
      '00444322',
      NULL,
      '04313113',
      '12030141',
      NULL,
      '22342212',
      '41213221',
      '11110412',
      '11400100',
      '30221011',
      '11011304',
      '42230304',
      '14213114',
      NULL,
      '24402102',
      '43431113',
      '22312203',
      NULL,
      '13210141',
      '23112041',
      '22134024',
      '43120043',
      '33022444',
      '42334212',
      '30432303',
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '1203323',
      1.111068,
      0,
      1,
      NULL,
      '240221',
      3.856690,
      ' 9-26-1979',
      ' 4-27-1986',
      22.095102,
      NULL,
      16,
      4.730226,
      10.693692,
      7.918460,
      47.641549,
      3,
      NULL,
      1,
      3.264288,
      12,
      7.965078,
      NULL,
      7,
      8.976501,
      9,
      4,
      21.163121,
      6.071077,
      1,
      17.829917,
      25,
      NULL,
      NULL,
      2.538914,
      NULL,
      51,
      94,
      72.800188,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-25-1984',
      50.131825,
      50,
      36.013435,
      NULL,
      41,
      NULL,
      60.465208,
      NULL,
      NULL,
      53.333585,
      13.473753,
      25,
      ' 8-23-1996',
      14.937168,
      2.640236,
      NULL,
      43,
      21.363317,
      63.976319,
      3.225273,
      NULL,
      NULL,
      3,
      '10- 6-1977',
      9.418927,
      5,
      11,
      1.301801,
      9.917132,
      5,
      NULL,
      1.091518,
      NULL,
      48.114661,
      NULL,
      4,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-25-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45.048304,
      3,
      7.291209,
      NULL,
      1,
      19,
      ' 2-16-1980',
      6,
      NULL,
      14,
      NULL,
      ' 5-29-1992',
      NULL,
      NULL,
      69.908400,
      ' 0-25-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      30.408659,
      NULL,
      NULL,
      73,
      25.319292,
      67.733602,
      0,
      68.827397,
      1,
      1.391742,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      52,
      0,
      1.785862,
      15,
      9,
      21,
      NULL,
      NULL,
      59,
      0.299634,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      64,
      78.456883,
      23.103072,
      NULL,
      51.977878,
      5.234772,
      48,
      52,
      1,
      NULL,
      NULL,
      6.236540,
      4.144461,
      21.073265,
      NULL,
      68,
      0.688224,
      NULL,
      NULL,
      13,
      9,
      4,
      30,
      27.133512,
      NULL,
      NULL,
      NULL,
      8,
      4.937008,
      4,
      1,
      0,
      0.403046,
      1.250078,
      68,
      NULL,
      ' 8- 6-1988',
      ' 6- 7-1977',
      ' 6- 5-1978',
      ' 0- 1-1981',
      NULL,
      ' 7-29-1992',
      NULL);
commit;
end;
/


