set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7808199';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '2',
      '3',
      '1',
      '0',
      '1',
      '3',
      '0',
      '3',
      '2',
      '3',
      NULL,
      '0',
      '1',
      '1',
      '1',
      '1',
      '2',
      '2',
      '0',
      '2',
      '2',
      '1',
      '3',
      '',
      '3',
      '',
      '2',
      NULL,
      '2',
      NULL,
      NULL,
      '',
      '',
      '0',
      '1',
      '1',
      '3',
      '4',
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '2',
      '423',
      '41143412',
      24,
      5,
      '0140220',
      0,
      1.426300,
      NULL,
      NULL,
      '000410',
      5.222190,
      ' 3-14-1988',
      ' 5- 5-2002',
      106,
      NULL,
      10.549129,
      16,
      26,
      NULL,
      87,
      10.872138,
      23.265881,
      NULL,
      4,
      19.582534,
      5.134880,
      6,
      0.636337,
      4.814599,
      2,
      4.057367,
      NULL,
      19.984274,
      NULL,
      2,
      27.123477,
      1,
      0.571547,
      75.323796,
      8.046295,
      32.284475,
      88.929710,
      1.829730,
      NULL,
      NULL,
      38,
      20.091978,
      20.047390,
      32.156596,
      54.961602,
      101.210668,
      ' 8-26-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.940827,
      NULL,
      57.824200,
      13.912515,
      16.127610,
      2.093486,
      NULL,
      1,
      1,
      14,
      1.090017,
      1,
      72.879163,
      1.310395,
      1.297227,
      NULL,
      NULL,
      NULL,
      NULL,
      '11- 8-1978',
      119.292482,
      75.011503,
      34,
      18,
      17,
      17,
      81.107384,
      53,
      5.221219,
      69.848574,
      NULL,
      79,
      NULL,
      31,
      1.265364,
      31,
      39.292382,
      54.864089,
      34,
      2.885623,
      ' 8- 3-2002',
      20,
      14,
      ' 6-19-1991',
      0,
      12.148617,
      NULL,
      5,
      NULL,
      NULL,
      0.344044,
      16.862098,
      1.739392,
      96.615663,
      3.944809,
      1.077761,
      2.094109,
      7,
      NULL,
      2,
      1.413373,
      0.621610,
      ' 3-26-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      109,
      37.143753,
      ' 3- 2-1986',
      NULL,
      NULL,
      NULL,
      13,
      NULL,
      31.783991,
      ' 6-19-2003',
      16.972143,
      NULL,
      NULL,
      17.267576,
      36,
      ' 1-23-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      15,
      ' 6-23-1988',
      NULL,
      NULL,
      NULL,
      ' 7- 1-1989',
      NULL,
      130.446573,
      ' 3-14-1991',
      NULL,
      NULL,
      22.032070,
      NULL,
      NULL,
      34.129518,
      1.742286,
      15,
      ' 5-21-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


