set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9668580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4114',
      '00101323',
      '00324242',
      '22120304',
      '21404010',
      '14334311',
      '02310212',
      '42030434',
      '13431132',
      NULL,
      NULL,
      '42044233',
      '20312241',
      '33442243',
      '13234001',
      '43420124',
      '12412310',
      NULL,
      '31423013',
      '00142242',
      '34302442',
      '22444033',
      '13114201',
      '30334424',
      '22412222',
      '13030401',
      '42320304',
      '02001020',
      NULL,
      NULL,
      '30313030',
      '24043014',
      '03124044',
      '33003122',
      '12331011',
      NULL,
      NULL,
      '31013011',
      '32311004',
      '00134041',
      '22332101',
      NULL,
      '13002424',
      '13011333',
      '11341313',
      NULL,
      '44',
      33.414444,
      3.810941,
      NULL,
      2.831634,
      NULL,
      2,
      NULL,
      '220433',
      2.203395,
      NULL,
      ' 2-10-2000',
      189.249537,
      6.728103,
      15.829355,
      8.146397,
      23.788729,
      NULL,
      18.996598,
      NULL,
      16.248548,
      NULL,
      16.682222,
      2.904743,
      12.313174,
      13.298742,
      29.871566,
      NULL,
      16,
      2.451632,
      NULL,
      7,
      NULL,
      8,
      8.072548,
      17,
      1,
      17.380276,
      94,
      53.422361,
      8.806733,
      90.725690,
      102.959250,
      ' 6-20-1981',
      44,
      25,
      18.309378,
      16,
      36.249033,
      213.296973,
      ' 5-16-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      59.191718,
      26.358237,
      8.777608,
      11,
      5,
      4.030196,
      ' 9-14-1994',
      5.584607,
      1,
      73.990798,
      2.445558,
      1,
      73,
      1.358012,
      2.697016,
      33.764245,
      NULL,
      NULL,
      NULL,
      ' 3-19-1976',
      58,
      30.090376,
      79,
      68.793297,
      NULL,
      43,
      26.225951,
      45,
      99.471239,
      75,
      109,
      NULL,
      ' 6-11-1992',
      22,
      16.167719,
      24.672028,
      54,
      NULL,
      78,
      1,
      ' 7- 2-1980',
      7.470291,
      NULL,
      '11- 6-1979',
      0,
      18.163844,
      NULL,
      5,
      5.672134,
      NULL,
      1,
      25.943872,
      NULL,
      107.041322,
      3,
      2.761258,
      17.169241,
      14,
      1,
      0.281584,
      6.699542,
      1.549578,
      ' 9-24-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 6-19-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 0-2000',
      27.658716,
      NULL,
      3,
      0.693714,
      ' 8- 0-1979',
      56.023357,
      66.033005,
      ' 1-16-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      ' 6-19-1974',
      31,
      7.293734,
      23,
      '10- 3-2003',
      1.984069,
      18.771998,
      ' 6-20-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


