set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7426050';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1242',
      '24330410',
      '40230120',
      '22432144',
      '21122444',
      '03311042',
      NULL,
      NULL,
      '10234113',
      NULL,
      '03212111',
      '44311314',
      '33014024',
      NULL,
      '20303323',
      NULL,
      '33330120',
      '41343241',
      '20040322',
      '21324214',
      '24402314',
      '30423323',
      '03442140',
      '41142210',
      '43321214',
      NULL,
      '04104002',
      NULL,
      '41432113',
      '42431441',
      '12134032',
      '43224330',
      NULL,
      '00121222',
      '43423433',
      '04231424',
      '31120134',
      '10244103',
      '42001321',
      '11420342',
      '44120213',
      '41432022',
      NULL,
      '40124103',
      '01224424',
      '',
      '',
      NULL,
      NULL,
      '0212223',
      2.429640,
      NULL,
      0,
      NULL,
      '121414',
      0,
      ' 6-19-1988',
      ' 9- 3-1981',
      NULL,
      NULL,
      19.836906,
      NULL,
      1,
      0,
      61,
      7,
      0.280996,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      31.055009,
      NULL,
      16,
      5.854075,
      NULL,
      15,
      NULL,
      19.230117,
      80.888838,
      16.108574,
      NULL,
      46,
      144.435441,
      55.519508,
      NULL,
      146.682834,
      196,
      NULL,
      65,
      25.105580,
      30,
      NULL,
      NULL,
      161.332074,
      ' 3- 7-1990',
      3.724283,
      1.248163,
      0.606802,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.613653,
      1,
      1.645640,
      NULL,
      NULL,
      0.169869,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-28-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 7-1974',
      25,
      102,
      128,
      119.754944,
      68.672796,
      45.421785,
      52,
      25.348495,
      6.641959,
      26.487286,
      76.564003,
      25.164590,
      ' 4-28-1999',
      24.471898,
      NULL,
      27,
      NULL,
      63,
      2,
      15,
      NULL,
      32.795859,
      4.554447,
      NULL,
      7,
      25,
      23,
      26,
      26,
      9.691517,
      NULL,
      21.270003,
      NULL,
      63.228365,
      1,
      0.671269,
      23.505931,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      48.597007,
      17.791002,
      35.080477,
      ' 6-22-1995',
      1.873134,
      NULL,
      ' 7- 7-1981',
      8.779520,
      22,
      23.731886,
      18,
      ' 3-11-1981',
      39,
      0,
      NULL,
      ' 5-11-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.651739,
      7,
      NULL,
      2.656250,
      0.525283,
      NULL,
      3,
      3,
      11,
      1.541927,
      1.805886,
      37.023968,
      NULL,
      3,
      230.675029,
      NULL,
      24,
      NULL,
      1.161947,
      NULL,
      0.402042,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      9.033861,
      NULL,
      NULL,
      0,
      NULL,
      18,
      0,
      5.698755,
      8,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      4.801379,
      NULL,
      29,
      22.573672,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      10,
      0,
      0,
      0.807320,
      3,
      0,
      2.013947,
      NULL,
      NULL,
      ' 8-28-1987',
      ' 4-16-1993',
      ' 2-19-1994',
      '11-12-1990',
      ' 0- 1-1987',
      ' 9-16-1997',
      NULL);
commit;
end;
/


