set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9400554';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4220',
      NULL,
      '41434202',
      '12003202',
      '44424040',
      '44334012',
      '23323010',
      '14400221',
      '03404322',
      '04222031',
      '33302341',
      '20410342',
      '32111123',
      NULL,
      '32103134',
      '14304142',
      '11142412',
      NULL,
      '42144004',
      NULL,
      '21043411',
      NULL,
      NULL,
      NULL,
      '10113312',
      NULL,
      '32324122',
      NULL,
      '03402233',
      '42044131',
      '11243134',
      '30030331',
      NULL,
      NULL,
      '24023242',
      '31300100',
      '33120010',
      NULL,
      '11210231',
      '03304414',
      '04104433',
      '40434004',
      '23312421',
      '32020223',
      '00224334',
      '323',
      '04',
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      '344234',
      5.441221,
      ' 4-23-1998',
      NULL,
      136,
      NULL,
      14.573598,
      NULL,
      NULL,
      1.653175,
      NULL,
      NULL,
      NULL,
      NULL,
      6.675161,
      2.208577,
      31.646663,
      6,
      23.697469,
      9,
      NULL,
      NULL,
      6.752694,
      12,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      94.430906,
      46.670073,
      4,
      122,
      0.361802,
      73,
      ' 7- 1-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      52,
      0,
      1.225592,
      35,
      0,
      1,
      32,
      NULL,
      NULL,
      NULL,
      ' 4-28-1976',
      11,
      40.091633,
      37,
      85.519707,
      57,
      NULL,
      73.654162,
      64,
      123.479434,
      NULL,
      84.606842,
      17,
      ' 4-17-1984',
      0.138690,
      0,
      3.434140,
      10,
      NULL,
      6.772390,
      NULL,
      ' 7- 2-1990',
      31.965926,
      11.429810,
      ' 9-20-1995',
      0.228796,
      0.036702,
      NULL,
      13,
      12,
      NULL,
      0.645921,
      1,
      0,
      83.373658,
      1,
      0,
      7,
      5.401320,
      3.683886,
      4,
      0.239490,
      NULL,
      ' 4-19-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      NULL,
      24.649592,
      ' 4-12-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      ' 2-22-1988',
      48.642705,
      2.191989,
      7,
      NULL,
      1,
      111.765112,
      ' 9-18-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      20,
      NULL,
      NULL,
      25.199082,
      26,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-14-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


