set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9698125';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '04434321',
      '20121011',
      '21400424',
      '22110123',
      '01030212',
      '01322104',
      '04202321',
      NULL,
      '01101322',
      '10302133',
      '42004001',
      '03120114',
      '34304432',
      '22040200',
      NULL,
      '03141234',
      '41213344',
      '30314314',
      NULL,
      NULL,
      '43304420',
      '33124312',
      '31424341',
      '22434430',
      '03240204',
      '43313421',
      '12402430',
      '44041341',
      '00233341',
      '22213401',
      '00204042',
      '41343031',
      '01224223',
      '11234140',
      '33120324',
      NULL,
      '14401104',
      '34143043',
      '20230411',
      '30024334',
      '32203241',
      '20412434',
      '40202202',
      '31030144',
      '044',
      '30',
      34.366639,
      16,
      '1231431',
      1.555890,
      0,
      NULL,
      NULL,
      NULL,
      4.237315,
      ' 3-25-1990',
      ' 9-12-2001',
      NULL,
      132.662238,
      6.097559,
      13.614846,
      NULL,
      16.978450,
      NULL,
      2.020681,
      17,
      2.645672,
      NULL,
      NULL,
      21.158911,
      17.312058,
      1.789905,
      2,
      NULL,
      5,
      10.066809,
      20.155420,
      18,
      4.127597,
      127,
      20.207857,
      1.769801,
      89,
      81,
      54.563557,
      24,
      168,
      173,
      NULL,
      11.862237,
      12.420728,
      20.357044,
      8.506584,
      NULL,
      57.879006,
      ' 3- 0-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      66,
      7,
      NULL,
      5.428757,
      3.869755,
      2,
      NULL,
      NULL,
      2.075702,
      20,
      NULL,
      0,
      NULL,
      0.903328,
      0,
      65,
      NULL,
      NULL,
      NULL,
      ' 0- 9-1986',
      90.808576,
      91.192552,
      108,
      72.792919,
      NULL,
      81.664160,
      65,
      NULL,
      NULL,
      54,
      NULL,
      74.489692,
      ' 1-23-1980',
      20.035837,
      3.855441,
      22.292134,
      22.658918,
      NULL,
      NULL,
      8,
      '11-14-1989',
      5.407544,
      5,
      ' 5- 8-1999',
      3.942171,
      14,
      NULL,
      NULL,
      NULL,
      0,
      3.022560,
      15,
      0.390929,
      42,
      0,
      3.598118,
      10,
      8.398663,
      1,
      2.021044,
      1,
      0.026520,
      ' 9-17-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      73.364176,
      22.284585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      38,
      ' 0- 5-1983',
      NULL,
      7.229565,
      ' 0-24-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      7.097532,
      ' 2-17-1990',
      36.812431,
      63,
      3,
      ' 5-25-1997',
      0.164468,
      62.401052,
      ' 8-28-1988',
      9.095477,
      14,
      16.810922,
      7.015731,
      ' 6- 5-1994',
      25.129343,
      1,
      2,
      ' 9-17-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


