set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9698125';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '0',
      '0',
      '1',
      '0',
      '4',
      '2',
      '2',
      '3',
      '3',
      '0',
      '0',
      '4',
      '3',
      '2',
      '4',
      '1',
      '0',
      '3',
      '2',
      '3',
      '2',
      '2',
      '4',
      '',
      '2',
      '',
      '0',
      '3',
      NULL,
      '1',
      '0',
      '',
      '',
      NULL,
      NULL,
      '4',
      '2',
      '4',
      '1',
      '4',
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      NULL,
      33,
      4.957899,
      '4033210',
      NULL,
      22,
      1,
      NULL,
      '203243',
      0.258283,
      ' 9-19-2000',
      ' 7- 4-1996',
      102.118180,
      238.346247,
      47.557331,
      17,
      2.948200,
      2,
      64.416322,
      NULL,
      14,
      NULL,
      18,
      11,
      30.795355,
      2.829621,
      19.351998,
      9.346933,
      NULL,
      NULL,
      12.711652,
      20.695402,
      47.813003,
      20.387754,
      33,
      15,
      1.601974,
      63.701001,
      23,
      35,
      26.984294,
      NULL,
      166,
      ' 9-12-1980',
      28.038952,
      38,
      NULL,
      NULL,
      112,
      63,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      66,
      3,
      9.688439,
      NULL,
      8,
      NULL,
      ' 2- 6-1984',
      NULL,
      0.594630,
      69.010457,
      0,
      1,
      169.967997,
      0.654506,
      NULL,
      18.040494,
      NULL,
      NULL,
      NULL,
      ' 1-20-1990',
      16.197013,
      68,
      35,
      84,
      22,
      90,
      NULL,
      85,
      70.805789,
      80,
      79.598304,
      62.515078,
      NULL,
      6,
      2.934665,
      4.859057,
      60,
      34.263892,
      58,
      NULL,
      ' 4-14-1982',
      13.323160,
      14,
      NULL,
      0,
      13,
      16,
      7,
      27,
      9.633249,
      1,
      14.428564,
      1,
      101.446035,
      NULL,
      0,
      14.129027,
      13,
      2.814940,
      0.749284,
      0,
      1.631391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      98,
      7,
      ' 6- 0-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.234384,
      ' 6-27-2002',
      9,
      7.317582,
      '11- 5-1975',
      74,
      NULL,
      '11- 5-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      '10- 1-1987',
      NULL,
      26.556764,
      6,
      NULL,
      5,
      63,
      ' 9-13-1986',
      13,
      5,
      NULL,
      5,
      ' 3-18-2003',
      12,
      1.303986,
      59.092457,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


