set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9872391';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      '4',
      '2',
      '0',
      '1',
      NULL,
      '0',
      '0',
      '0',
      '2',
      '1',
      '0',
      '3',
      '1',
      '1',
      '4',
      '4',
      '2',
      '0',
      '4',
      '0',
      '3',
      '2',
      NULL,
      '3',
      '',
      NULL,
      '4',
      '2',
      '1',
      '3',
      NULL,
      NULL,
      '0',
      '2',
      '3',
      '1',
      NULL,
      NULL,
      '0',
      '4',
      '1',
      '0',
      NULL,
      NULL,
      '42133111',
      43,
      NULL,
      '2432020',
      3.064207,
      1,
      3,
      1,
      '113101',
      5.901873,
      '11- 3-1985',
      ' 4- 6-1974',
      NULL,
      45,
      8,
      NULL,
      11.646008,
      NULL,
      NULL,
      NULL,
      16.936400,
      10.819651,
      16,
      6.816502,
      NULL,
      9.772882,
      0.718098,
      NULL,
      9,
      10.499289,
      NULL,
      1.165266,
      0,
      0.776757,
      34.639979,
      7,
      1.444906,
      30.213119,
      NULL,
      24,
      67,
      NULL,
      94.019121,
      NULL,
      19,
      0,
      26.692541,
      6,
      72.883326,
      102.648215,
      ' 1-26-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40.444344,
      11,
      NULL,
      6.993184,
      0.862792,
      ' 1- 6-1988',
      0.228829,
      1.666324,
      100.737526,
      0.074441,
      1.690444,
      NULL,
      12.254283,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-16-1977',
      38.638482,
      32.897989,
      51.375120,
      NULL,
      7,
      31.521166,
      NULL,
      3.295205,
      1,
      20,
      NULL,
      19,
      ' 2- 5-2000',
      NULL,
      12,
      NULL,
      17.655290,
      8.517156,
      NULL,
      5,
      NULL,
      3,
      5.888281,
      ' 9- 9-1978',
      1,
      0.828629,
      7.869671,
      NULL,
      NULL,
      9,
      0,
      7,
      NULL,
      51.977223,
      0.992281,
      NULL,
      1.953788,
      NULL,
      8.699846,
      0,
      1,
      1,
      ' 0-14-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      45,
      109,
      ' 8-28-1993',
      NULL,
      NULL,
      NULL,
      11.582730,
      ' 5-18-1983',
      14,
      ' 1-22-2000',
      13.141491,
      0,
      ' 9-12-1985',
      27,
      80,
      '11-25-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.630431,
      NULL,
      NULL,
      7.078606,
      NULL,
      ' 5- 4-1989',
      0.538406,
      185,
      NULL,
      1.121487,
      61,
      NULL,
      79,
      NULL,
      68.353202,
      0,
      36.831869,
      ' 9-19-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


