set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9872391';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '1',
      '1',
      '1',
      '4',
      '2',
      '3',
      '1',
      '3',
      '2',
      '4',
      '1',
      '2',
      NULL,
      '0',
      '2',
      '2',
      NULL,
      NULL,
      '0',
      NULL,
      '3',
      '0',
      '2',
      '',
      '3',
      '',
      '1',
      '3',
      '0',
      NULL,
      '0',
      '',
      '',
      '2',
      '2',
      '2',
      NULL,
      NULL,
      '2',
      '2',
      '1',
      '4',
      '3',
      '2',
      '014',
      '03134214',
      31.376239,
      1.862480,
      '0321124',
      0,
      44,
      1,
      0,
      '140332',
      0.396288,
      NULL,
      ' 4-28-1992',
      110.500565,
      83,
      25,
      13.933163,
      13,
      NULL,
      21.770618,
      1.895150,
      4.673014,
      3.412075,
      11,
      2.829661,
      NULL,
      16.337059,
      15,
      3,
      0.922911,
      4,
      30.883069,
      13,
      19,
      5,
      NULL,
      9.946314,
      0,
      23,
      52.450532,
      11.443640,
      68.988920,
      24.765201,
      NULL,
      ' 3-15-1974',
      NULL,
      NULL,
      2,
      21.370328,
      58.407624,
      99.918606,
      ' 9-19-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      35.023126,
      38,
      NULL,
      18.638106,
      13,
      0.940569,
      ' 2-22-1997',
      7,
      1.578824,
      107.824284,
      NULL,
      1,
      77,
      0,
      2,
      3.386801,
      NULL,
      NULL,
      NULL,
      '11- 9-1986',
      45,
      5.850235,
      NULL,
      54,
      3.851726,
      51.838511,
      44,
      72.413071,
      42.674059,
      61.098623,
      19,
      NULL,
      NULL,
      12,
      NULL,
      6,
      3,
      52.014070,
      31.653789,
      9,
      ' 6-11-1980',
      NULL,
      10.568033,
      ' 9- 9-1993',
      1,
      NULL,
      NULL,
      NULL,
      11.707543,
      5,
      0,
      0.300347,
      0,
      15,
      1.512435,
      NULL,
      NULL,
      7,
      1.654019,
      8.810774,
      0.849643,
      0.669755,
      ' 2-20-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 5- 0-1981',
      40.937438,
      NULL,
      6.558759,
      11,
      NULL,
      118.090958,
      NULL,
      ' 5-15-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      ' 5-25-1976',
      28,
      16,
      2,
      NULL,
      NULL,
      134,
      ' 0-12-1974',
      NULL,
      NULL,
      8,
      33,
      NULL,
      NULL,
      1.142602,
      56.583758,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


