set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9406400';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '33242441',
      '10023333',
      '12444303',
      '04321331',
      '14212421',
      '21441110',
      '03323310',
      '31114432',
      '33442303',
      '24202404',
      NULL,
      '11043022',
      '41424432',
      NULL,
      '04221423',
      '42143300',
      '22130210',
      '24422242',
      NULL,
      '20002244',
      '00023332',
      '42421324',
      '14034221',
      NULL,
      NULL,
      '22440004',
      '04030201',
      '13034004',
      '40212244',
      '21431231',
      '11214000',
      '14233130',
      NULL,
      '32321330',
      '44120002',
      '31340403',
      '03110340',
      NULL,
      NULL,
      NULL,
      '40102014',
      '43223141',
      '14233002',
      '41330414',
      '344',
      '31',
      NULL,
      NULL,
      '3424330',
      1,
      1,
      0,
      NULL,
      '123032',
      NULL,
      ' 1- 7-1992',
      ' 0-10-1994',
      NULL,
      NULL,
      7,
      NULL,
      3,
      19.559242,
      22,
      11.573454,
      13.818356,
      2.084168,
      NULL,
      2.710789,
      14,
      NULL,
      17,
      4.340960,
      3.716686,
      1.532661,
      1,
      NULL,
      32,
      NULL,
      NULL,
      NULL,
      0,
      29.842900,
      130.725467,
      69.205981,
      45.903518,
      NULL,
      NULL,
      ' 8- 3-1990',
      6,
      27.902801,
      NULL,
      10,
      NULL,
      61.754407,
      NULL,
      2.402042,
      2,
      0,
      0,
      2,
      NULL,
      NULL,
      4,
      0.068832,
      1,
      6,
      1.123276,
      1.220923,
      2.637642,
      1,
      0,
      1.248734,
      0.282608,
      NULL,
      3.882430,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-24-2001',
      52,
      NULL,
      35,
      17.571164,
      NULL,
      0,
      ' 3-20-1994',
      1,
      1.209368,
      196,
      NULL,
      0.782941,
      102.758195,
      1.683351,
      2,
      31.644590,
      NULL,
      NULL,
      NULL,
      NULL,
      19.444564,
      51.937325,
      77.059625,
      NULL,
      NULL,
      62.129894,
      59.381124,
      NULL,
      NULL,
      39,
      19,
      35.800770,
      ' 8-17-1987',
      20.098755,
      NULL,
      18.905178,
      40,
      18,
      19,
      10.970845,
      ' 1- 9-1987',
      1,
      NULL,
      NULL,
      0.344467,
      9.761265,
      8,
      9.833154,
      8,
      NULL,
      1,
      1.967048,
      0.178275,
      43,
      14.872634,
      1.560802,
      5,
      13,
      5,
      4.045451,
      3,
      1,
      '11- 2-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29.307706,
      ' 4-12-1980',
      11.326084,
      ' 1- 2-1997',
      15,
      4,
      ' 4-27-1993',
      25.643688,
      15,
      ' 5-27-1980',
      1,
      3.445124,
      ' 8-26-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      11,
      '10- 8-2001',
      6,
      0,
      9.718796,
      ' 5-18-1986',
      NULL,
      NULL,
      ' 3-27-1979',
      5,
      5,
      7,
      39.578761,
      ' 4-14-1981',
      27,
      NULL,
      NULL,
      ' 1-22-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


