set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9406400';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      '3',
      '3',
      NULL,
      '1',
      '4',
      '3',
      NULL,
      '1',
      NULL,
      '0',
      '3',
      '0',
      '4',
      '1',
      '1',
      '3',
      NULL,
      '2',
      '0',
      NULL,
      '0',
      '1',
      NULL,
      '4',
      '',
      '2',
      '0',
      NULL,
      '1',
      NULL,
      '',
      '',
      '0',
      '1',
      '2',
      '4',
      NULL,
      '2',
      '2',
      '3',
      '1',
      NULL,
      NULL,
      '204',
      '13',
      8.496288,
      5.347946,
      '0042444',
      1.887584,
      115.303231,
      NULL,
      NULL,
      '312301',
      1.533487,
      ' 8-19-2003',
      ' 6-29-1979',
      41,
      NULL,
      15.455572,
      NULL,
      15,
      8.963743,
      36.687584,
      13.577791,
      4.424616,
      4.695859,
      NULL,
      10.804076,
      18,
      NULL,
      3,
      16,
      8,
      5.674310,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      81,
      198,
      NULL,
      133.926158,
      74.642516,
      7,
      ' 9-27-1981',
      37,
      NULL,
      20,
      18,
      3,
      NULL,
      ' 2- 3-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      58,
      15,
      19.774925,
      4.963900,
      21,
      NULL,
      ' 6- 5-1975',
      NULL,
      0.476960,
      153,
      1.319119,
      1.424892,
      156.937798,
      1,
      NULL,
      30,
      NULL,
      NULL,
      NULL,
      '11-18-1996',
      81.445677,
      35.438843,
      84.920107,
      4,
      45.775592,
      62.390041,
      NULL,
      52.320420,
      11.835770,
      27,
      86.041783,
      NULL,
      ' 0-20-1979',
      14,
      3,
      11,
      11,
      24.456873,
      46,
      9,
      ' 8-23-2003',
      NULL,
      3,
      '10-23-1978',
      NULL,
      7,
      14,
      10.691895,
      12,
      4,
      2,
      8,
      1,
      32,
      1,
      0,
      4.465696,
      24,
      0.618910,
      3,
      1.100958,
      NULL,
      ' 2- 8-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      79,
      85,
      ' 2-22-1976',
      NULL,
      NULL,
      NULL,
      8,
      '11-23-1986',
      19,
      '10-14-1982',
      12.239194,
      9,
      ' 8-10-1983',
      NULL,
      112.157820,
      ' 0-28-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      ' 2- 1-1982',
      NULL,
      12.870251,
      NULL,
      ' 7-17-1997',
      1,
      NULL,
      ' 3-21-1992',
      2,
      NULL,
      12.249223,
      0,
      ' 1-12-1987',
      34.590559,
      0.731970,
      NULL,
      ' 5-21-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


