set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9706629';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      '0',
      '3',
      '4',
      '4',
      '3',
      '2',
      '0',
      '2',
      NULL,
      '4',
      '3',
      '3',
      NULL,
      '0',
      '4',
      '3',
      NULL,
      NULL,
      '2',
      '0',
      '4',
      '3',
      '',
      '1',
      '',
      NULL,
      '4',
      '0',
      '4',
      NULL,
      '',
      '',
      '0',
      '2',
      '3',
      '1',
      '0',
      '1',
      '0',
      '3',
      '4',
      NULL,
      '0',
      NULL,
      '11240211',
      32,
      45.221064,
      '0134401',
      2,
      1,
      1,
      NULL,
      '412433',
      NULL,
      NULL,
      ' 7-29-1996',
      NULL,
      82.597207,
      22,
      3,
      31.730912,
      22,
      87.809496,
      10,
      9.767868,
      20.937908,
      8,
      12,
      16,
      11,
      27.777121,
      9.963666,
      0,
      5.822344,
      25,
      NULL,
      27,
      NULL,
      142,
      28.244426,
      0,
      98.040483,
      NULL,
      81.361541,
      145.583910,
      129.383317,
      207,
      '11-16-1995',
      4.583398,
      64,
      27.123260,
      15.725405,
      187.940807,
      72,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      52.002153,
      58,
      15,
      9,
      20,
      0,
      ' 4-20-1987',
      0,
      0.924225,
      181,
      1.199274,
      4,
      101.471010,
      0.758094,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      99,
      47.595446,
      39.876820,
      5.190966,
      NULL,
      9.866819,
      12.847005,
      26,
      58.296184,
      34.119915,
      53,
      ' 0-11-2003',
      4,
      NULL,
      24.576687,
      NULL,
      NULL,
      17.567043,
      NULL,
      ' 6-21-1980',
      9.957376,
      8,
      ' 6-22-1997',
      18.033870,
      10,
      26,
      14,
      NULL,
      7,
      NULL,
      23,
      0,
      55.120891,
      NULL,
      5,
      NULL,
      NULL,
      2,
      1,
      1.085451,
      NULL,
      ' 7-16-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.830747,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10-24-1998',
      35,
      ' 9- 4-2003',
      10,
      11,
      ' 8-11-1986',
      111.859854,
      48.404463,
      '10-18-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2.199183,
      ' 8-25-1993',
      NULL,
      1,
      48,
      ' 2-23-1988',
      0.709843,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


