set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8112687';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3014',
      '23244101',
      '31310212',
      '23420313',
      NULL,
      NULL,
      '22024041',
      '14041322',
      '12134224',
      '23002002',
      '43210010',
      '13302311',
      '31221332',
      '34033422',
      '34434312',
      '40010414',
      NULL,
      '12302442',
      NULL,
      NULL,
      '33440321',
      '04302244',
      '44334133',
      NULL,
      '04322304',
      '20334142',
      '41004040',
      '01441401',
      '13113432',
      NULL,
      '32303133',
      '11434214',
      '31122210',
      '01311322',
      '21200240',
      '32020114',
      '23340024',
      '13334423',
      '34002043',
      NULL,
      NULL,
      '34411333',
      '34110241',
      '22211442',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '0302232',
      1,
      NULL,
      3,
      NULL,
      '232142',
      3,
      NULL,
      ' 2-15-2002',
      44,
      NULL,
      8.877820,
      6.892207,
      16.604697,
      0,
      NULL,
      2.237832,
      16,
      3.888601,
      NULL,
      9.384715,
      22,
      4.135887,
      NULL,
      10,
      1,
      NULL,
      NULL,
      NULL,
      4.779940,
      3,
      NULL,
      2.351417,
      NULL,
      51,
      115,
      67,
      14,
      NULL,
      125.814857,
      ' 2- 1-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.653000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      2.661101,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-10-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      23.061721,
      90,
      34.788149,
      68,
      55,
      23.573532,
      28.565616,
      53.636551,
      41,
      NULL,
      96.239857,
      NULL,
      7.362180,
      22.842601,
      NULL,
      23.764267,
      40.906010,
      50.619271,
      4,
      ' 1-28-1997',
      25,
      1,
      '10-23-1982',
      2.282044,
      10.652598,
      12.955544,
      19.092973,
      11,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-10-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.927880,
      17.325644,
      18.266378,
      ' 4- 9-1999',
      NULL,
      NULL,
      ' 9-26-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      61.928313,
      NULL,
      NULL,
      69.649126,
      23,
      58,
      32,
      NULL,
      1.889275,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      8,
      12.816833,
      2,
      5,
      3,
      1,
      NULL,
      1.565813,
      NULL,
      ' 2- 2-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 8-1999',
      NULL);
commit;
end;
/


