set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9846734';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '4',
      '1',
      '0',
      '1',
      '0',
      '1',
      '4',
      '0',
      NULL,
      '1',
      NULL,
      '3',
      '1',
      NULL,
      '1',
      NULL,
      '1',
      NULL,
      '3',
      '0',
      '1',
      '3',
      '4',
      NULL,
      '1',
      '',
      '1',
      '4',
      '2',
      '2',
      '3',
      NULL,
      '',
      '2',
      '3',
      '1',
      '4',
      '3',
      '0',
      '3',
      '3',
      '0',
      '1',
      '3',
      NULL,
      '44313341',
      25,
      61.723645,
      '4020032',
      3,
      NULL,
      NULL,
      0,
      '102123',
      1.448580,
      NULL,
      ' 5-21-1991',
      59,
      159.392288,
      50,
      NULL,
      0.686673,
      8.737550,
      116,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      13.244455,
      11.383142,
      NULL,
      6,
      16,
      16.790140,
      20,
      43.865237,
      21,
      NULL,
      NULL,
      NULL,
      121,
      83.064351,
      59,
      NULL,
      NULL,
      43,
      ' 2-20-1984',
      13.664838,
      19,
      30,
      11.807355,
      NULL,
      123,
      ' 8-25-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      15.586354,
      5.294206,
      4.138771,
      3.754508,
      NULL,
      ' 0-19-1999',
      1.589863,
      1.243630,
      134.952817,
      0,
      0.193581,
      191.103321,
      0.674909,
      NULL,
      92.817269,
      NULL,
      NULL,
      NULL,
      ' 2-14-1994',
      12.436578,
      2.374068,
      11,
      NULL,
      NULL,
      6,
      55,
      NULL,
      49.827794,
      40,
      83,
      31,
      NULL,
      30,
      26.671460,
      35.487702,
      125,
      NULL,
      NULL,
      10,
      ' 8- 1-1993',
      23,
      NULL,
      ' 7- 1-2002',
      9.852083,
      18,
      24.565618,
      NULL,
      NULL,
      1.741692,
      0.898964,
      9.319947,
      NULL,
      99,
      0.947939,
      0.129939,
      15,
      9,
      NULL,
      1,
      1,
      1,
      '11- 2-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      36,
      4.073837,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      ' 4-14-1984',
      41.378697,
      '11- 1-2003',
      7.159291,
      9.591768,
      ' 9-19-1976',
      NULL,
      26.227296,
      ' 2-21-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      19.222104,
      NULL,
      52.591224,
      30.905735,
      43.962165,
      ' 8-10-2003',
      7.652248,
      NULL,
      ' 6- 2-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


