set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '5102105';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4140',
      NULL,
      '13021432',
      '11204044',
      '22422443',
      NULL,
      '03131041',
      NULL,
      '11041322',
      '01040422',
      '41344003',
      '31443320',
      '13320141',
      '04444423',
      '34423311',
      '21001041',
      '03000132',
      '12340004',
      '42240323',
      NULL,
      '12044430',
      '40401410',
      NULL,
      '33400130',
      '22332213',
      '00120421',
      NULL,
      NULL,
      '44320221',
      '12020224',
      '14142133',
      '33214342',
      NULL,
      '30122021',
      NULL,
      '12213032',
      NULL,
      NULL,
      NULL,
      '30331140',
      NULL,
      '34420314',
      '03004101',
      '21034031',
      '13134404',
      '',
      '',
      NULL,
      NULL,
      '2332232',
      0.212698,
      0,
      NULL,
      NULL,
      '002024',
      0,
      '11-28-1992',
      NULL,
      8,
      NULL,
      39,
      19,
      13.051177,
      15.695881,
      97.723078,
      19.064641,
      NULL,
      7,
      NULL,
      8.222809,
      39.766242,
      7.156011,
      NULL,
      11,
      5,
      21,
      52,
      NULL,
      NULL,
      18.344719,
      33.924728,
      1,
      NULL,
      162.538028,
      32,
      109.753991,
      69.317409,
      121.344270,
      121.615679,
      NULL,
      42.721045,
      NULL,
      27.438115,
      11.361649,
      126,
      50,
      ' 4-19-1999',
      1,
      NULL,
      0.963574,
      1.260119,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.255426,
      2.396181,
      1,
      0.772375,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-26-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-12-1987',
      80,
      12.533437,
      60,
      89.815175,
      135.938245,
      53,
      64,
      121.278418,
      11.296543,
      NULL,
      34,
      0.943718,
      ' 0- 6-1982',
      27,
      6,
      22.382967,
      NULL,
      NULL,
      26,
      5.544450,
      ' 0-15-1986',
      30.079448,
      29,
      NULL,
      NULL,
      11,
      10,
      NULL,
      25,
      3,
      NULL,
      15.417428,
      NULL,
      NULL,
      NULL,
      1.891026,
      1.746133,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 5-29-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      34,
      12,
      NULL,
      ' 5-11-1975',
      0.944985,
      62.936675,
      ' 5- 3-1980',
      18.993415,
      28,
      21,
      0,
      ' 0- 6-1991',
      47,
      NULL,
      87,
      '10- 6-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      100.132786,
      1,
      NULL,
      NULL,
      103,
      33.756735,
      10,
      99,
      24.502970,
      5,
      NULL,
      0,
      1,
      27.991107,
      NULL,
      NULL,
      NULL,
      1.567365,
      0.906870,
      85,
      0,
      3,
      204.337986,
      NULL,
      19.396856,
      NULL,
      NULL,
      NULL,
      0.672168,
      0.559769,
      0.683287,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      11.420482,
      NULL,
      NULL,
      0.701167,
      1,
      8,
      1.949915,
      NULL,
      15.142073,
      6.108615,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.639988,
      NULL,
      14,
      14,
      20.659334,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.732442,
      4.403455,
      4,
      1,
      0.565416,
      NULL,
      NULL,
      ' 5- 5-1993',
      ' 8- 9-2001',
      ' 5-17-1996',
      '10-21-1977',
      NULL,
      NULL,
      ' 7- 3-1986',
      NULL);
commit;
end;
/


