set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9006632';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '2412',
      '10401110',
      '43344101',
      '20333420',
      '43123231',
      '12340422',
      '11412322',
      '33201010',
      NULL,
      '43244204',
      '34420410',
      '40414103',
      '23321231',
      '13224202',
      '44114412',
      '03131012',
      '20142412',
      '10040031',
      '04014220',
      '43323311',
      '42123024',
      '33403322',
      NULL,
      '14034211',
      '34022004',
      NULL,
      '14044113',
      '32243140',
      '02421410',
      '42322202',
      NULL,
      '03314443',
      '41231302',
      '43120344',
      NULL,
      '24114134',
      '33441412',
      NULL,
      NULL,
      '03004310',
      '13330203',
      NULL,
      '31333113',
      '13133201',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '1020212',
      1,
      1.185772,
      3,
      NULL,
      '120003',
      1.484559,
      '11-26-1982',
      ' 7-29-1998',
      26,
      NULL,
      16.845759,
      NULL,
      19.685054,
      5.086653,
      3.621890,
      NULL,
      8.638623,
      12,
      28,
      3,
      26.560811,
      10.244962,
      28.246630,
      1.226479,
      1.153413,
      NULL,
      16.175527,
      8,
      7.676731,
      9,
      9.113622,
      NULL,
      NULL,
      59,
      148.797576,
      23,
      26,
      NULL,
      11.368868,
      ' 4-21-1994',
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      1.255617,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.551600,
      3.360202,
      0,
      1.669193,
      2.477302,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-15-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1- 1-1977',
      NULL,
      70.195102,
      NULL,
      75.388085,
      57.166400,
      25,
      52.949675,
      12.561079,
      68,
      76,
      104.060682,
      NULL,
      ' 0- 0-1998',
      9,
      18.302231,
      10.551267,
      NULL,
      77.609754,
      NULL,
      5.868006,
      NULL,
      10,
      0,
      ' 9-15-1999',
      NULL,
      13.073061,
      NULL,
      6,
      5.581155,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1.810071,
      3,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9-22-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      17.897449,
      NULL,
      1.818183,
      ' 7-29-1988',
      5,
      90,
      ' 8-11-1974',
      3.825596,
      100.864021,
      12.790395,
      15,
      ' 1-25-1988',
      6.909302,
      1,
      34.008501,
      '11- 8-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      115.117467,
      12,
      46,
      76.445777,
      86.955711,
      NULL,
      8,
      NULL,
      7.766794,
      NULL,
      1,
      NULL,
      105.617476,
      0.888625,
      NULL,
      31,
      NULL,
      0,
      152.972754,
      5,
      NULL,
      115,
      NULL,
      NULL,
      34.496179,
      0.471859,
      45,
      0.122010,
      1.510604,
      1.392741,
      5.945544,
      NULL,
      NULL,
      14,
      NULL,
      18,
      19,
      20,
      24,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.602291,
      54,
      1.411927,
      0,
      62,
      NULL,
      NULL,
      2,
      29,
      26,
      25.733588,
      73,
      2,
      2,
      5,
      0,
      0,
      0.545450,
      1.168924,
      1.698570,
      NULL,
      NULL,
      ' 8- 8-1983',
      ' 1- 3-1983',
      NULL,
      NULL,
      ' 4- 2-1982',
      NULL,
      NULL);
commit;
end;
/


