set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9015650';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0044',
      '12022214',
      '22404231',
      '11411432',
      '00431104',
      '14033020',
      '12022430',
      '20100031',
      NULL,
      '33424201',
      '24002332',
      NULL,
      '32111133',
      '31003021',
      '10014002',
      '43422133',
      NULL,
      NULL,
      '23112320',
      '44314131',
      '13310333',
      NULL,
      '20411010',
      '00013144',
      '33221233',
      '04103400',
      NULL,
      '43234120',
      NULL,
      '14124230',
      NULL,
      '11020300',
      '11422424',
      '01222422',
      '24012021',
      '11031004',
      '13131203',
      NULL,
      '21432304',
      '00401211',
      '32123001',
      NULL,
      '31403311',
      '30031344',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '0320440',
      0.997459,
      0.964312,
      3,
      NULL,
      '322010',
      2,
      ' 9- 5-1987',
      ' 0-27-1987',
      49.306439,
      NULL,
      NULL,
      21,
      23,
      15,
      59.577642,
      6,
      22.859650,
      10.823960,
      NULL,
      17.053160,
      30,
      0,
      NULL,
      3.711520,
      10.340799,
      8,
      NULL,
      10,
      NULL,
      2.208093,
      103,
      1,
      NULL,
      128,
      152,
      46,
      121,
      123,
      104.294880,
      ' 4- 2-1982',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      NULL,
      3.852058,
      NULL,
      NULL,
      NULL,
      NULL,
      1.556652,
      1.516802,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-22-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '11-22-1982',
      57,
      NULL,
      NULL,
      NULL,
      NULL,
      9.058673,
      70,
      23,
      59,
      NULL,
      49.634818,
      47.944877,
      ' 3- 5-1985',
      13.483641,
      NULL,
      NULL,
      54,
      67,
      74,
      11,
      ' 0- 4-1995',
      13,
      NULL,
      ' 8-18-1981',
      NULL,
      10.266930,
      NULL,
      6,
      1,
      NULL,
      NULL,
      22.398489,
      NULL,
      35.376571,
      2.416367,
      2.454611,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3- 0-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      61.980772,
      NULL,
      NULL,
      ' 4-20-1980',
      2.175345,
      NULL,
      ' 3- 7-1999',
      11,
      135.355005,
      NULL,
      39,
      ' 4-14-2002',
      53.965144,
      NULL,
      31,
      ' 2-18-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      6.702676,
      83,
      NULL,
      35,
      14.849334,
      NULL,
      7.779671,
      NULL,
      10.859771,
      91.933841,
      0.288856,
      1.298550,
      81.981612,
      NULL,
      NULL,
      NULL,
      1.847048,
      0.012477,
      81.557679,
      NULL,
      NULL,
      80,
      8,
      12,
      65,
      1,
      NULL,
      0.007834,
      0,
      0,
      NULL,
      1,
      1.950199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      98,
      1.981646,
      1,
      NULL,
      0.121967,
      NULL,
      2,
      2,
      1,
      21.825633,
      1.936147,
      26,
      1,
      2,
      73,
      4.505636,
      21.390878,
      12,
      45,
      92,
      NULL,
      97,
      8.759477,
      1,
      0,
      4.350726,
      1,
      1,
      0.848962,
      0.010107,
      51,
      ' 1-23-1975',
      ' 5-13-1991',
      NULL,
      ' 6-12-1994',
      '11-13-1987',
      ' 1-17-1979',
      NULL,
      NULL);
commit;
end;
/


