set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9019484';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4',
      '1',
      '0',
      '4',
      NULL,
      '3',
      '3',
      '1',
      '0',
      '0',
      '4',
      NULL,
      '2',
      '0',
      '2',
      '0',
      NULL,
      '1',
      '4',
      '3',
      NULL,
      '1',
      NULL,
      '0',
      '',
      '3',
      '',
      '1',
      '4',
      '3',
      NULL,
      '1',
      NULL,
      '',
      '0',
      NULL,
      '0',
      '3',
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      '0',
      '4',
      '433',
      '01312120',
      NULL,
      NULL,
      NULL,
      0,
      1.295561,
      NULL,
      NULL,
      '341243',
      2.627873,
      ' 6-15-1975',
      ' 0- 7-1976',
      34.619736,
      79.276204,
      17,
      14,
      35,
      NULL,
      36,
      17,
      4.107220,
      16,
      11,
      0.130137,
      NULL,
      7,
      NULL,
      18.249045,
      4.931364,
      NULL,
      NULL,
      8.423351,
      52.546815,
      16.369749,
      71.127597,
      15.234376,
      NULL,
      49.863905,
      166.222012,
      51.642767,
      132.470771,
      71.851131,
      53,
      ' 1- 2-2000',
      5.065178,
      44,
      0,
      21.369085,
      NULL,
      207.700059,
      ' 9- 0-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      81,
      12.091768,
      2,
      8,
      NULL,
      5.829915,
      ' 3-26-1990',
      NULL,
      0,
      181.971310,
      1.781647,
      0.135860,
      156.268022,
      3,
      1,
      67.910951,
      NULL,
      NULL,
      NULL,
      ' 6-27-1977',
      88,
      4,
      40.710126,
      22,
      39.141157,
      5.880868,
      61.866690,
      NULL,
      31,
      NULL,
      NULL,
      81.800339,
      ' 5-28-2000',
      NULL,
      18.302807,
      28,
      49,
      84.097486,
      NULL,
      7,
      ' 2-23-1993',
      18.053887,
      7.658307,
      NULL,
      8.342036,
      NULL,
      8,
      16.858587,
      9,
      0,
      NULL,
      15,
      3.988117,
      8,
      2.070603,
      1,
      0,
      8.321531,
      11,
      0.825148,
      1,
      1.346638,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      182,
      3.401630,
      ' 3-28-1976',
      NULL,
      NULL,
      NULL,
      57.893357,
      ' 0-18-1992',
      11,
      ' 0- 8-1996',
      2,
      7.308144,
      NULL,
      NULL,
      70.515307,
      '10-21-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      20.512159,
      ' 7-16-2002',
      60,
      6,
      5,
      ' 0- 9-1984',
      5.668131,
      106,
      ' 3- 3-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


