set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8108494';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '0',
      NULL,
      '4',
      '2',
      '1',
      '2',
      NULL,
      '3',
      '3',
      '4',
      '2',
      '2',
      '2',
      '2',
      '3',
      '0',
      '3',
      NULL,
      NULL,
      '2',
      NULL,
      '2',
      '3',
      '',
      '4',
      '',
      NULL,
      '4',
      '0',
      '4',
      '3',
      '',
      '',
      '1',
      '2',
      '2',
      '0',
      NULL,
      '4',
      '3',
      NULL,
      '3',
      '4',
      '3',
      '310',
      '33243031',
      28.612834,
      22.830714,
      '2013234',
      1.258362,
      1.270869,
      0,
      0,
      '230222',
      3.281943,
      ' 7-24-2001',
      '11- 9-1975',
      35.386707,
      NULL,
      22.987867,
      18,
      NULL,
      10.673114,
      39.516496,
      NULL,
      7.851124,
      3.097450,
      5.422172,
      NULL,
      17,
      NULL,
      10,
      9.736834,
      10,
      6,
      32,
      5.165792,
      NULL,
      11,
      94.031496,
      7.049340,
      0.030952,
      65.394098,
      195.594370,
      39,
      51,
      132,
      120.022402,
      ' 8- 1-1980',
      NULL,
      34,
      28.361332,
      NULL,
      116,
      172.694987,
      ' 2-19-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.470060,
      2,
      7.695493,
      11,
      NULL,
      '10-17-1994',
      NULL,
      1,
      NULL,
      1,
      4,
      87,
      1,
      1.199204,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      24,
      42,
      13.121753,
      NULL,
      40,
      19,
      45,
      30.813107,
      NULL,
      42,
      26,
      9.799415,
      ' 8- 1-1981',
      9.564147,
      16,
      NULL,
      41.575867,
      17,
      32,
      8.976471,
      ' 8-15-1988',
      7,
      7,
      ' 5- 8-1997',
      9.019258,
      6.786191,
      5,
      9,
      12,
      4,
      0.521305,
      6.014778,
      0,
      75,
      1.055534,
      0.586636,
      NULL,
      3.340386,
      7,
      0,
      1.202038,
      1,
      '10-27-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16.989549,
      ' 1-23-1980',
      4.189947,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      8,
      '10- 0-1997',
      57.721833,
      26.661735,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 1-11-1987',
      19,
      29,
      NULL,
      44.998337,
      ' 1- 7-1999',
      39.855097,
      NULL,
      NULL,
      ' 9- 0-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


