set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1042',
      '40334111',
      NULL,
      '41330232',
      '21303200',
      '24333243',
      NULL,
      '34012324',
      NULL,
      NULL,
      NULL,
      '42313002',
      '41433401',
      '43044242',
      '20231131',
      NULL,
      '13423113',
      '02441212',
      '10022023',
      '41423330',
      '12201403',
      '13104411',
      '43240023',
      '33214114',
      '00241441',
      '24032103',
      '20224040',
      '14234134',
      '32224123',
      '40102441',
      '14341020',
      '21321411',
      '34224424',
      NULL,
      '44340413',
      '33144144',
      '12403004',
      '00041141',
      NULL,
      '34033342',
      '12310233',
      '10413022',
      '04134030',
      '13202201',
      '31402341',
      NULL,
      '',
      NULL,
      NULL,
      NULL,
      1.444982,
      1.769404,
      NULL,
      NULL,
      NULL,
      0.889262,
      ' 1-19-1992',
      '10-26-1974',
      56.781030,
      NULL,
      27.193703,
      7.318031,
      24,
      9,
      NULL,
      12.626064,
      7.095873,
      14,
      36.209462,
      NULL,
      17,
      12.575104,
      14.934511,
      1.831610,
      27.884377,
      1,
      58.888736,
      7,
      73.875742,
      24.540729,
      80,
      NULL,
      NULL,
      93,
      60,
      95,
      189,
      89,
      149,
      NULL,
      33,
      50,
      18,
      28.127910,
      206.981385,
      18.005953,
      NULL,
      1,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.988861,
      0.146055,
      NULL,
      1,
      0,
      0.441292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-18-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.895120,
      NULL,
      33,
      41,
      45.668410,
      NULL,
      101,
      63.286020,
      36,
      11,
      73,
      90,
      ' 6-22-1975',
      20.607213,
      NULL,
      1.515290,
      63,
      0,
      135,
      8.434926,
      ' 9- 5-2000',
      3,
      14.901225,
      ' 8-18-1982',
      11,
      2,
      26.515240,
      25,
      29,
      4.230982,
      NULL,
      8.617648,
      NULL,
      108.270792,
      3.673127,
      20,
      17.835542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      18.107545,
      3,
      ' 7-26-1996',
      1.942041,
      39.315436,
      ' 3-24-1983',
      NULL,
      43,
      3.541476,
      50.628586,
      ' 2-27-1989',
      68,
      1.247231,
      NULL,
      ' 0-26-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      76,
      0,
      66,
      130.403628,
      67.370064,
      34.557268,
      NULL,
      13,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      80.353096,
      NULL,
      NULL,
      NULL,
      1,
      1,
      77.974880,
      0.139935,
      1.966967,
      23,
      NULL,
      2,
      118,
      0,
      86.585651,
      0.768598,
      1,
      1,
      1.356584,
      1,
      0,
      121.856877,
      53,
      NULL,
      23.277114,
      97,
      NULL,
      1.109909,
      NULL,
      7,
      0,
      0.346146,
      0.707158,
      56.842662,
      0,
      78,
      NULL,
      80.490139,
      1.761730,
      1,
      NULL,
      NULL,
      9.198931,
      0,
      88.104672,
      NULL,
      25.188695,
      NULL,
      NULL,
      0,
      1.889031,
      3.516262,
      NULL,
      1.291895,
      NULL,
      0.939855,
      NULL,
      ' 8- 0-1999',
      ' 4-19-1995',
      ' 6-11-1999',
      ' 5-11-1989',
      '11-12-1983',
      NULL,
      ' 9-14-1991',
      NULL);
commit;
end;
/


