set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4442',
      '14001043',
      '33103314',
      '41440321',
      '11130313',
      NULL,
      NULL,
      '33112103',
      '14231030',
      '10042102',
      '03303041',
      '02134024',
      '24111320',
      '01104101',
      NULL,
      NULL,
      '30301223',
      NULL,
      NULL,
      '40202430',
      '23113404',
      '40024240',
      '40112124',
      NULL,
      '23100131',
      '43143124',
      '34232214',
      '32212132',
      '44334212',
      '42434432',
      '12012441',
      '21144242',
      '02013001',
      '34401422',
      '22232232',
      NULL,
      '04020330',
      '24400220',
      '30112301',
      '41024441',
      NULL,
      NULL,
      '13022141',
      '31133234',
      '00200442',
      '230',
      NULL,
      NULL,
      NULL,
      '3143110',
      3,
      12,
      NULL,
      NULL,
      '441114',
      2,
      ' 2- 7-1974',
      ' 2- 0-1984',
      NULL,
      NULL,
      7.978825,
      7,
      27.451967,
      20.850185,
      74.406275,
      11.077208,
      16,
      14.198526,
      13.246973,
      6,
      NULL,
      NULL,
      NULL,
      1.956024,
      17.511424,
      3.382933,
      NULL,
      1,
      NULL,
      18.372996,
      2.568201,
      NULL,
      1,
      110,
      123,
      28.461334,
      72,
      NULL,
      93,
      ' 0- 9-1990',
      NULL,
      56,
      1.930913,
      7.020490,
      11,
      54.631707,
      ' 8-17-2002',
      NULL,
      3,
      2,
      1,
      4,
      0.073167,
      0,
      NULL,
      1.363663,
      1.993168,
      1,
      1.950183,
      1,
      0,
      1,
      0,
      0.495950,
      0,
      NULL,
      1.636989,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 6-25-1985',
      83,
      NULL,
      NULL,
      NULL,
      8,
      3.341873,
      NULL,
      0.422984,
      1,
      NULL,
      0.209892,
      2.830818,
      56,
      0,
      1,
      94,
      NULL,
      NULL,
      107,
      ' 7-16-1982',
      68,
      65.161413,
      11.776676,
      21.668381,
      109.737282,
      40,
      70,
      12,
      NULL,
      25,
      108.441080,
      39.807188,
      ' 5- 4-1989',
      18.480084,
      3.997173,
      30.199522,
      23,
      19,
      41.667311,
      10,
      ' 9-22-1988',
      8.520560,
      24,
      ' 9-21-1975',
      8.362829,
      0.343733,
      5,
      12.862265,
      5.653771,
      11,
      1.217514,
      18,
      0.476339,
      58,
      NULL,
      4,
      15.405311,
      19,
      1,
      3,
      1.413876,
      1,
      NULL,
      NULL,
      3.448434,
      2.170339,
      ' 9- 7-2002',
      139.814773,
      1.524716,
      ' 9-24-1997',
      NULL,
      NULL,
      NULL,
      21,
      ' 0-24-1976',
      NULL,
      ' 1-23-1975',
      18.145748,
      12,
      '11-28-1975',
      72.623911,
      NULL,
      NULL,
      1,
      NULL,
      ' 1-11-2003',
      0.614916,
      7.148261,
      NULL,
      1,
      3,
      NULL,
      ' 2-23-1978',
      71.883916,
      NULL,
      17,
      ' 1-28-1987',
      1.960504,
      13.439957,
      ' 5- 4-2003',
      7,
      31.185574,
      NULL,
      NULL,
      NULL,
      55,
      0,
      77.271991,
      '11-28-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3);
commit;
end;
/


