set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '23023330',
      '31243122',
      '32100244',
      '44023041',
      '02320120',
      '42401334',
      '22030412',
      '20322442',
      '30224404',
      '00343001',
      '24000011',
      '34103020',
      '11202034',
      NULL,
      '20444142',
      '00303100',
      '03110141',
      '12010141',
      NULL,
      NULL,
      '23120413',
      '02100420',
      '02431322',
      '23042210',
      '04231433',
      '10112110',
      '34130011',
      '11403222',
      '33114401',
      '31131333',
      '40111021',
      '24322230',
      '20130300',
      '03033434',
      '24143134',
      '20013400',
      '31331423',
      NULL,
      '12213031',
      NULL,
      '44344021',
      '32401423',
      NULL,
      '10313221',
      '043',
      NULL,
      NULL,
      NULL,
      '1212134',
      2,
      94.355677,
      3,
      NULL,
      '031040',
      1.926133,
      NULL,
      ' 6-25-1994',
      13,
      NULL,
      7.298859,
      8.269546,
      34,
      8,
      NULL,
      13.452555,
      10.734422,
      16,
      17.779616,
      16,
      NULL,
      13,
      NULL,
      18.414325,
      NULL,
      18.671252,
      NULL,
      24.930845,
      21,
      11.103849,
      62,
      15.921109,
      0.168639,
      8.572434,
      48.248470,
      82.880019,
      75.106661,
      204.936586,
      156,
      ' 1-25-1977',
      35,
      43.568513,
      23.983242,
      9.992899,
      NULL,
      82.870335,
      NULL,
      0.028060,
      NULL,
      0,
      4,
      0.876443,
      1,
      NULL,
      1.692220,
      0,
      NULL,
      1,
      NULL,
      1.091441,
      2.018959,
      0.032882,
      0.833904,
      NULL,
      0.437042,
      1,
      1.573547,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-20-1977',
      NULL,
      12,
      4,
      1,
      2.354388,
      2.039954,
      ' 5-28-1974',
      0.754092,
      0.805708,
      NULL,
      0.020758,
      1,
      48.386740,
      1.326455,
      0.779586,
      67,
      NULL,
      NULL,
      NULL,
      ' 0-29-1999',
      58,
      95.205753,
      NULL,
      NULL,
      25,
      25,
      85,
      34,
      16.169367,
      31,
      57,
      11.275133,
      ' 6- 9-1981',
      15,
      9,
      4.522317,
      99.360762,
      NULL,
      NULL,
      NULL,
      '11-29-1981',
      27.552528,
      1,
      ' 6-23-2000',
      NULL,
      9.645103,
      3.596056,
      14,
      20,
      5,
      0,
      NULL,
      NULL,
      102.481902,
      2,
      0,
      16,
      10.562090,
      2.144277,
      1,
      2.552038,
      0.709615,
      ' 1-24-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      114.038869,
      5,
      '11-13-1992',
      NULL,
      NULL,
      NULL,
      2,
      ' 1- 6-1977',
      14.148577,
      ' 0-18-1975',
      9.506569,
      6.052882,
      NULL,
      82.869773,
      87,
      ' 7-11-1978',
      0.441617,
      0.602818,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      27,
      NULL,
      7,
      '10-11-1996',
      0,
      NULL,
      ' 6-28-1993',
      6.942424,
      65,
      15.695844,
      15.242265,
      ' 1- 8-1983',
      58.622602,
      NULL,
      109.790569,
      ' 8- 9-1988',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


