set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9023505';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '4',
      NULL,
      '3',
      '3',
      '1',
      '3',
      '3',
      NULL,
      '0',
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '1',
      '0',
      '4',
      '4',
      '1',
      '2',
      '0',
      '4',
      NULL,
      '',
      '4',
      '',
      NULL,
      '2',
      '4',
      '3',
      '3',
      '',
      '',
      '1',
      '3',
      '3',
      NULL,
      '3',
      '1',
      '0',
      '0',
      NULL,
      '0',
      NULL,
      '213',
      '20',
      13,
      28.423792,
      NULL,
      0,
      20.805351,
      2,
      NULL,
      NULL,
      NULL,
      ' 2- 4-1991',
      ' 8-18-1999',
      21.053976,
      173,
      9.805586,
      6,
      20,
      NULL,
      30.693716,
      7,
      3,
      NULL,
      10.289600,
      NULL,
      NULL,
      6,
      30,
      18,
      20,
      NULL,
      NULL,
      4,
      9,
      NULL,
      7,
      8.189175,
      1,
      NULL,
      88.462301,
      37.113010,
      21.824313,
      142.285839,
      138,
      NULL,
      15,
      NULL,
      NULL,
      18.726451,
      NULL,
      169,
      ' 5- 9-1981',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      73,
      5,
      4.138328,
      10.860695,
      0,
      NULL,
      '10- 8-1981',
      1,
      0,
      168,
      1.412725,
      1,
      46.210972,
      1.520439,
      1,
      22.438595,
      NULL,
      NULL,
      NULL,
      ' 7-11-1981',
      49.970903,
      NULL,
      NULL,
      80,
      65.206969,
      99.324439,
      69,
      86.326256,
      NULL,
      71.598699,
      29,
      18.115101,
      ' 1-21-1974',
      28,
      32.856785,
      1.021048,
      41,
      NULL,
      137,
      11.265040,
      ' 5- 4-1997',
      14,
      20,
      NULL,
      5,
      14,
      NULL,
      1,
      1.310824,
      4,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      7.842776,
      0.269871,
      NULL,
      ' 4-19-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      202.112692,
      23,
      ' 9-11-1986',
      NULL,
      NULL,
      NULL,
      30.766133,
      ' 7- 1-1992',
      34.550506,
      ' 8-20-1977',
      4,
      4.046942,
      ' 2-19-1975',
      55.342442,
      48,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      14.271088,
      ' 2-26-1993',
      46.638869,
      36.723977,
      NULL,
      ' 3- 6-1979',
      0,
      36,
      NULL,
      NULL,
      37,
      1,
      54.615117,
      ' 4- 4-1976',
      0,
      0.951656,
      28,
      '10- 4-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


