set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655442';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0112',
      '14220344',
      '31141402',
      '24403130',
      '44200044',
      '13413224',
      '04431243',
      NULL,
      '02231420',
      '11102131',
      NULL,
      NULL,
      '42312432',
      '41320134',
      '22144201',
      '04321300',
      '21132214',
      '40330422',
      '21032312',
      '10340140',
      '14230134',
      NULL,
      '00031431',
      '42414340',
      '34240431',
      '14413424',
      '24142141',
      '20210122',
      '13224404',
      NULL,
      '32112230',
      '32130022',
      '23331340',
      '12420104',
      '14220202',
      '23140244',
      '14404040',
      '01123104',
      '12130402',
      NULL,
      NULL,
      NULL,
      NULL,
      '31332241',
      '42102222',
      '243',
      '00',
      4,
      NULL,
      '1341240',
      1.602141,
      0.758278,
      3,
      NULL,
      '301341',
      3.110146,
      '11-17-1998',
      ' 7-22-2002',
      92,
      60,
      37.608763,
      20,
      13.412552,
      10.189846,
      NULL,
      NULL,
      20,
      1.050157,
      NULL,
      13.836974,
      29.324618,
      6,
      13.674827,
      19,
      31.231292,
      6,
      57,
      19.190394,
      10.494098,
      NULL,
      53,
      NULL,
      0,
      60,
      128.260725,
      84.879512,
      NULL,
      214.279038,
      NULL,
      ' 3-18-1996',
      11.642672,
      NULL,
      NULL,
      21,
      NULL,
      172.454004,
      ' 1- 0-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      21,
      1,
      NULL,
      20,
      NULL,
      ' 5-14-1994',
      1.373869,
      1.267459,
      126,
      0.553920,
      2.002377,
      NULL,
      1.632862,
      1.131844,
      17.628618,
      NULL,
      NULL,
      NULL,
      '11-29-1992',
      NULL,
      104.513257,
      NULL,
      22,
      89,
      21.535371,
      32.628422,
      NULL,
      NULL,
      10.311992,
      20.335203,
      75,
      ' 9- 1-2002',
      22.262224,
      5.715497,
      0.589030,
      33.944860,
      39,
      87,
      7,
      '10- 3-1974',
      9.143886,
      10,
      ' 0-21-1974',
      13.896156,
      NULL,
      11.530112,
      12.350882,
      0.549980,
      12.319023,
      NULL,
      24,
      0.199729,
      NULL,
      4,
      3,
      25.912830,
      NULL,
      1.278687,
      0,
      0.942525,
      0,
      ' 4-15-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      169,
      NULL,
      ' 1-25-1997',
      NULL,
      NULL,
      NULL,
      24.891994,
      NULL,
      35,
      '11- 2-1991',
      8,
      2.531018,
      ' 9-25-1994',
      98,
      0.008675,
      '10-11-1998',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      6.347801,
      ' 1- 8-2003',
      13.599526,
      7,
      32,
      ' 8-22-1982',
      1,
      99,
      '11-25-1975',
      10.105592,
      23,
      8.769366,
      16,
      ' 7- 4-1997',
      64.950073,
      0.785257,
      19.943622,
      '10-29-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


