set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9655442';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      '1',
      '0',
      '3',
      '0',
      '0',
      '0',
      '2',
      '4',
      '3',
      '3',
      '1',
      '0',
      '0',
      NULL,
      '2',
      '2',
      '2',
      '1',
      '2',
      '0',
      '0',
      '0',
      '',
      '0',
      '',
      NULL,
      '0',
      '4',
      '2',
      '1',
      '',
      '',
      '0',
      '0',
      '4',
      '1',
      '0',
      '3',
      '3',
      '4',
      '3',
      '0',
      '0',
      '340',
      '02',
      38.517747,
      NULL,
      '3134200',
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      22.044164,
      114.435908,
      30.598736,
      5,
      32.898033,
      4.550380,
      47.697308,
      0.584195,
      13,
      6,
      43.423374,
      7,
      0.026733,
      13.560435,
      3.562418,
      2.939586,
      6,
      NULL,
      75.725359,
      24.368734,
      73.913755,
      8,
      26,
      5.162186,
      NULL,
      53.596748,
      NULL,
      27,
      96,
      5.791491,
      NULL,
      ' 8- 0-1978',
      28.214755,
      68.024847,
      NULL,
      35,
      NULL,
      NULL,
      ' 6- 1-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      40.991612,
      35.005046,
      11,
      14.980363,
      16.854449,
      1,
      NULL,
      0.864460,
      0,
      59.810161,
      1,
      NULL,
      9.449183,
      0.032853,
      0,
      20,
      NULL,
      NULL,
      NULL,
      NULL,
      38.674711,
      NULL,
      69,
      74,
      45.620170,
      NULL,
      44,
      42,
      58.443933,
      36,
      31,
      57.429376,
      ' 3-26-1996',
      NULL,
      8,
      20.777713,
      43.787889,
      43.324942,
      1.126742,
      10,
      ' 7-20-1978',
      12.426472,
      NULL,
      ' 7- 7-1986',
      9,
      13,
      2.086043,
      NULL,
      22.636950,
      9.913274,
      1.850479,
      NULL,
      1.690141,
      124.890183,
      1.603100,
      0.388969,
      NULL,
      18,
      0.700270,
      1.383082,
      NULL,
      NULL,
      ' 7- 3-2001',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.151070,
      NULL,
      NULL,
      NULL,
      NULL,
      39,
      ' 5-19-2003',
      40.347971,
      NULL,
      18,
      17,
      NULL,
      25,
      7,
      ' 9- 6-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      ' 8-17-1984',
      55.779273,
      NULL,
      43,
      ' 1- 9-1984',
      0.613161,
      76,
      '11-18-1977',
      7,
      NULL,
      17.879318,
      28,
      ' 7-20-2003',
      0.519202,
      NULL,
      44,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


