set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9726580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '0',
      '0',
      '0',
      '0',
      '0',
      '0',
      '1',
      '0',
      '0',
      '3',
      NULL,
      '0',
      '2',
      '1',
      '4',
      '2',
      '1',
      NULL,
      NULL,
      NULL,
      '2',
      '1',
      '0',
      '1',
      '',
      '4',
      '',
      '0',
      '2',
      '2',
      '0',
      '4',
      '',
      NULL,
      NULL,
      '1',
      '0',
      '2',
      NULL,
      '4',
      '3',
      NULL,
      '4',
      '4',
      '4',
      '342',
      NULL,
      NULL,
      36,
      NULL,
      2.879909,
      NULL,
      1,
      NULL,
      '413220',
      1,
      ' 7-23-1982',
      ' 3- 9-1978',
      0,
      126.014939,
      5.983690,
      15.932295,
      27,
      10.577921,
      26,
      1,
      6.632551,
      5.289404,
      0,
      10,
      0,
      13.964661,
      14.384575,
      7.416889,
      16.620281,
      0,
      NULL,
      NULL,
      14.078893,
      4.265986,
      NULL,
      2.426984,
      NULL,
      1,
      118,
      60,
      142,
      0,
      116,
      ' 1-23-1996',
      51.623102,
      71.217149,
      3,
      3.912907,
      73,
      138.652265,
      ' 2-18-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      52,
      42.700022,
      52.147391,
      3,
      4.773111,
      2,
      ' 2-26-1974',
      1.390793,
      1,
      102,
      NULL,
      NULL,
      84,
      1,
      3.188654,
      18,
      NULL,
      NULL,
      NULL,
      '10-10-1988',
      67,
      NULL,
      NULL,
      4,
      NULL,
      62.451497,
      0,
      9.684133,
      NULL,
      19,
      42.333195,
      19.063298,
      '10- 2-1976',
      4.036416,
      15,
      NULL,
      12.684368,
      20,
      75.489626,
      8,
      ' 0-23-1988',
      2.816215,
      0,
      NULL,
      7.471956,
      6,
      7.206083,
      13.024690,
      7,
      6.615091,
      NULL,
      19,
      0.423105,
      66.213717,
      NULL,
      1,
      3.615007,
      20.656123,
      2,
      1,
      NULL,
      0.086908,
      ' 3- 4-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      13,
      ' 4-24-1991',
      NULL,
      NULL,
      NULL,
      17.653729,
      ' 8-24-2002',
      12,
      '10-24-1974',
      9,
      16.389495,
      NULL,
      5.323299,
      37,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      16,
      NULL,
      69.588148,
      NULL,
      29,
      NULL,
      0,
      138,
      '10- 9-1984',
      5,
      NULL,
      1.923764,
      102.631353,
      '11- 0-1987',
      70,
      0.914682,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


