set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9726580';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '1',
      NULL,
      '1',
      NULL,
      '3',
      '4',
      NULL,
      '0',
      '4',
      '1',
      '0',
      '2',
      '3',
      '2',
      '0',
      '2',
      '2',
      '2',
      '0',
      '3',
      '1',
      '4',
      '3',
      '',
      '3',
      '',
      '4',
      '4',
      '3',
      '3',
      '0',
      '',
      '',
      NULL,
      '4',
      NULL,
      '4',
      '3',
      '0',
      NULL,
      '4',
      '1',
      '0',
      '0',
      '131',
      '42444411',
      NULL,
      NULL,
      '4214013',
      NULL,
      46,
      1,
      0,
      NULL,
      NULL,
      ' 7-20-1992',
      '11- 5-1982',
      67,
      132,
      12,
      21,
      NULL,
      13,
      24.305588,
      8.756725,
      14.999924,
      2,
      NULL,
      NULL,
      9,
      13.505048,
      19.948524,
      18.921234,
      19,
      NULL,
      46.931380,
      23.638958,
      33,
      NULL,
      92,
      9,
      0.490525,
      NULL,
      NULL,
      15.644544,
      36,
      161,
      NULL,
      ' 9-13-1975',
      NULL,
      60,
      24,
      15,
      127.168419,
      162,
      ' 1-19-1992',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      15,
      5.229313,
      NULL,
      9,
      9,
      ' 2-18-1981',
      0.285435,
      1.401144,
      71.222347,
      NULL,
      0.506768,
      170.602544,
      0.330768,
      5,
      50,
      NULL,
      NULL,
      NULL,
      ' 8-12-1985',
      60.469177,
      62.747147,
      44,
      20.119558,
      NULL,
      7.673760,
      NULL,
      75,
      72,
      8,
      NULL,
      53.949672,
      ' 6-26-1993',
      19.086259,
      NULL,
      9.106234,
      31.749811,
      9.056412,
      51.988702,
      NULL,
      NULL,
      NULL,
      17,
      ' 9-13-1987',
      NULL,
      12.932977,
      0.358952,
      26.391764,
      18,
      NULL,
      NULL,
      9,
      0.119913,
      135.075279,
      1.157247,
      0.918126,
      NULL,
      18.272844,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      16,
      ' 8- 8-2003',
      NULL,
      ' 8- 2-1991',
      9.746934,
      5,
      ' 1-23-1982',
      99,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      9.877468,
      ' 8-20-1985',
      72,
      59,
      52.563963,
      ' 8-15-2003',
      0.308321,
      29.046704,
      ' 5-29-2000',
      0.504259,
      20.705348,
      18,
      2.321219,
      ' 9-16-2000',
      NULL,
      1,
      110,
      ' 1-27-1987',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


