set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9987687';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '1',
      '4',
      '1',
      '0',
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      '3',
      '1',
      '4',
      '2',
      '4',
      NULL,
      '1',
      '0',
      '3',
      NULL,
      '0',
      '1',
      '2',
      NULL,
      '2',
      '',
      '3',
      '',
      '3',
      '1',
      '3',
      '2',
      '0',
      '',
      '',
      '0',
      NULL,
      NULL,
      '4',
      '2',
      '3',
      '2',
      '1',
      '3',
      '0',
      '4',
      '240',
      '4',
      20.283777,
      29,
      '3333243',
      NULL,
      1,
      NULL,
      0,
      '140103',
      1,
      ' 6-23-1992',
      '10-26-1988',
      NULL,
      41.476446,
      6.029617,
      6.837580,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.179976,
      37,
      12,
      14.266496,
      3,
      22,
      8,
      18,
      14,
      NULL,
      NULL,
      39.078844,
      NULL,
      57.433917,
      NULL,
      NULL,
      124,
      NULL,
      17,
      93.192267,
      73.932829,
      79,
      '11- 0-1980',
      NULL,
      0,
      9.834365,
      38,
      150,
      139,
      ' 1-19-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      51.495740,
      10,
      NULL,
      8.278777,
      1.354937,
      5.938436,
      NULL,
      1.090849,
      0.475023,
      NULL,
      NULL,
      0,
      74,
      NULL,
      1.275808,
      85,
      NULL,
      NULL,
      NULL,
      '11- 6-1977',
      NULL,
      96.422901,
      NULL,
      48.809429,
      4,
      NULL,
      26.410524,
      95,
      37,
      106.355022,
      88,
      NULL,
      ' 8-15-1978',
      1.614727,
      NULL,
      9,
      22.273314,
      73,
      95.654119,
      NULL,
      ' 4-17-1988',
      20.197618,
      16,
      ' 4- 1-1982',
      NULL,
      0.843890,
      11.644406,
      13.507592,
      15,
      6,
      NULL,
      8.143515,
      0,
      70,
      0,
      3.335257,
      1.858273,
      NULL,
      NULL,
      1,
      0,
      0,
      ' 0-23-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      ' 6- 0-1984',
      NULL,
      NULL,
      NULL,
      5.523546,
      ' 1-28-1983',
      17,
      NULL,
      18,
      NULL,
      ' 5-17-1977',
      NULL,
      127,
      ' 4-11-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      23,
      ' 4- 4-2002',
      NULL,
      43.041228,
      12.408806,
      ' 0- 9-1994',
      1,
      83,
      '11- 6-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


