set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8602311';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '3',
      '3',
      '3',
      '4',
      '3',
      '4',
      NULL,
      '1',
      '3',
      '2',
      '1',
      '1',
      '2',
      '1',
      '0',
      '1',
      '1',
      '0',
      NULL,
      NULL,
      '0',
      NULL,
      '2',
      '4',
      '',
      '3',
      '',
      NULL,
      NULL,
      '4',
      NULL,
      '2',
      '',
      NULL,
      NULL,
      '3',
      '1',
      NULL,
      NULL,
      '2',
      '1',
      NULL,
      NULL,
      '2',
      NULL,
      '312',
      '11041042',
      19.920095,
      3,
      '2422130',
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.656310,
      ' 0- 8-2000',
      ' 8- 0-1986',
      30,
      117,
      53,
      NULL,
      5.240809,
      NULL,
      NULL,
      14,
      NULL,
      4,
      11,
      1.984516,
      4,
      14.281974,
      11.452276,
      22,
      16,
      NULL,
      23,
      10.680712,
      NULL,
      NULL,
      NULL,
      NULL,
      1.323214,
      NULL,
      147,
      NULL,
      65.075932,
      NULL,
      151,
      ' 3-21-1982',
      1.875780,
      6.969320,
      0,
      NULL,
      206.178362,
      229,
      ' 3-28-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.263804,
      19.521744,
      NULL,
      25,
      7.566166,
      4.067941,
      '10-15-1974',
      NULL,
      0.224763,
      NULL,
      1,
      0,
      NULL,
      0.306974,
      0,
      30.191011,
      NULL,
      NULL,
      NULL,
      ' 6- 3-2001',
      46,
      111.821097,
      36,
      NULL,
      24.847325,
      NULL,
      89.180219,
      55.643295,
      106,
      NULL,
      82.147205,
      115.248155,
      NULL,
      15.649090,
      4.670848,
      12,
      63,
      46.142272,
      85,
      9.472026,
      ' 8-18-1979',
      4,
      2,
      ' 1-16-1986',
      6,
      3,
      9.894663,
      0.844545,
      NULL,
      2.346513,
      NULL,
      3.852757,
      1,
      72.904480,
      2.452157,
      0.142026,
      7,
      1.580808,
      10.446537,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.393999,
      ' 1-23-1980',
      NULL,
      NULL,
      NULL,
      9,
      ' 7-19-2002',
      10,
      ' 0-27-1991',
      11.063111,
      0.354267,
      ' 3- 2-1993',
      9.296693,
      41,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      2,
      '11-28-1977',
      40.466426,
      NULL,
      20,
      ' 3-27-1979',
      NULL,
      120.638005,
      '10-22-1985',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


