set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9510460';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '11010001',
      '14230214',
      '30302324',
      NULL,
      '22014032',
      '12341041',
      '34440142',
      '12340424',
      '31312310',
      NULL,
      NULL,
      '32142141',
      '11221002',
      '14201413',
      NULL,
      '41233021',
      '33233332',
      '13201333',
      NULL,
      '01122414',
      '41122241',
      '00434432',
      '13320430',
      '41413144',
      '10030202',
      '30040022',
      '10431410',
      '43001110',
      NULL,
      NULL,
      '44431312',
      '44333213',
      '34012023',
      '10400211',
      NULL,
      '20343102',
      '22222014',
      '31243333',
      '44010323',
      '43410312',
      NULL,
      '03114040',
      '41030020',
      NULL,
      '424',
      NULL,
      15,
      6,
      '1321121',
      NULL,
      1.973101,
      1,
      NULL,
      '002014',
      3.187301,
      ' 0-25-1986',
      '10- 1-1974',
      43.352586,
      74.338234,
      16.946955,
      15.155572,
      NULL,
      11.528496,
      8.705587,
      2.756083,
      8.144092,
      11,
      NULL,
      2,
      25.583953,
      NULL,
      4.726365,
      7,
      10.748353,
      14.727394,
      NULL,
      17.253827,
      9.170749,
      17.888661,
      11.585894,
      3,
      0.055682,
      1.663750,
      55.011990,
      62.284397,
      116,
      95.965052,
      12,
      ' 1-15-1991',
      30,
      NULL,
      0.737003,
      27.568771,
      NULL,
      186.729673,
      ' 5-20-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      53,
      20,
      6.555482,
      11,
      0.532032,
      3,
      '11- 9-1996',
      NULL,
      1,
      89.779811,
      1,
      NULL,
      22.214603,
      1.502097,
      1,
      63,
      NULL,
      NULL,
      NULL,
      NULL,
      89.716779,
      35,
      NULL,
      75,
      36,
      77.854917,
      103.378022,
      76,
      NULL,
      NULL,
      81.558918,
      57,
      ' 2-27-1992',
      3.905747,
      7.990389,
      6.812840,
      37,
      54.740914,
      36,
      NULL,
      ' 2-22-1975',
      16,
      10.633695,
      ' 4- 4-1974',
      6,
      7.273375,
      NULL,
      NULL,
      1,
      0.380021,
      1,
      19,
      0,
      NULL,
      0,
      10.165665,
      9.322416,
      19.007498,
      0.995259,
      0.516745,
      1.238222,
      1,
      ' 1-15-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      95.585112,
      1,
      ' 0-13-1998',
      NULL,
      NULL,
      NULL,
      14.120927,
      NULL,
      11.801627,
      '11- 3-1995',
      7.400595,
      1,
      ' 3-17-1976',
      53.354518,
      90,
      ' 8-13-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      24,
      ' 8-21-1984',
      47,
      8,
      10.894704,
      ' 3-12-1992',
      0,
      140.983892,
      ' 4-23-1983',
      7,
      72.640025,
      16.894112,
      NULL,
      NULL,
      26,
      NULL,
      74.998085,
      ' 3-23-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


