set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8216084';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '04011102',
      '43113011',
      '43233213',
      NULL,
      NULL,
      '30241000',
      '04142210',
      '22233414',
      '22441320',
      '32431410',
      '32113221',
      '41203043',
      '21244001',
      '41422443',
      '31224124',
      '14102112',
      NULL,
      '32132134',
      '02213321',
      '12131130',
      '32343212',
      '21014243',
      '11211330',
      '43232200',
      NULL,
      '24201420',
      '13404231',
      '14443344',
      '44034234',
      '22432224',
      '42323332',
      '22203133',
      NULL,
      '11043212',
      '43243440',
      '30122044',
      '00320303',
      '40044320',
      '21403432',
      NULL,
      NULL,
      '03313101',
      '34340433',
      '12323323',
      '420',
      '34',
      18.393107,
      2,
      '2312143',
      3.534926,
      0.628716,
      2,
      NULL,
      '133242',
      4.771774,
      NULL,
      NULL,
      NULL,
      108.604677,
      31.203575,
      13.712133,
      25,
      15.241323,
      123.300619,
      24,
      32,
      NULL,
      25.418366,
      23.457169,
      2.578930,
      14.183058,
      33,
      2.170372,
      27,
      NULL,
      11.448233,
      8.954121,
      15,
      NULL,
      149.181915,
      28.615571,
      1.093811,
      NULL,
      71,
      76.256953,
      129.622800,
      208,
      163.754399,
      ' 2- 3-1991',
      NULL,
      23,
      20,
      NULL,
      117,
      197.898929,
      '11-14-1994',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      25,
      7,
      2.744339,
      3.023578,
      1.089928,
      4.912850,
      NULL,
      1.037965,
      0,
      153.369031,
      1,
      0.791101,
      48,
      0.132203,
      1.107629,
      81.485966,
      NULL,
      NULL,
      NULL,
      NULL,
      61.603902,
      49.132647,
      22,
      17,
      NULL,
      63,
      85,
      NULL,
      42.697417,
      8,
      16.468215,
      23,
      NULL,
      13,
      14.269109,
      5.773667,
      60.651231,
      49.311503,
      NULL,
      8,
      NULL,
      NULL,
      5,
      ' 7-14-2001',
      4,
      NULL,
      14.407758,
      NULL,
      4.337246,
      8,
      NULL,
      1.944415,
      0.341776,
      78,
      NULL,
      1,
      4,
      1.450241,
      0.466594,
      3.531722,
      0,
      0,
      ' 5-28-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      26,
      NULL,
      ' 0-28-1981',
      NULL,
      NULL,
      NULL,
      53,
      ' 9-21-1995',
      45,
      NULL,
      3,
      12.283783,
      NULL,
      NULL,
      47,
      ' 0- 8-1979',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      ' 6-16-2002',
      28.832547,
      26.419593,
      43,
      ' 4- 4-1976',
      1.548817,
      34,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


