set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8627743';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '33320134',
      NULL,
      '40040121',
      '23302003',
      '34110411',
      NULL,
      '01301002',
      '41043120',
      NULL,
      '24442102',
      '21211031',
      NULL,
      '04233410',
      '31021321',
      '22420401',
      '22141432',
      '33110343',
      '42241440',
      '00143011',
      NULL,
      '14110043',
      '34300001',
      '40140122',
      '43242241',
      '02103442',
      '42311124',
      '22404124',
      '12341424',
      '32414110',
      '12011032',
      '42124011',
      '10321343',
      '20322004',
      NULL,
      '02033224',
      '31214102',
      '30043312',
      '43113341',
      '04202320',
      '34130432',
      '31302032',
      '42402101',
      '20131424',
      NULL,
      NULL,
      '30',
      NULL,
      NULL,
      '2431410',
      1,
      0,
      3,
      NULL,
      '022111',
      NULL,
      ' 9-16-1991',
      ' 0-19-1994',
      1.440477,
      NULL,
      38,
      14,
      NULL,
      11.082051,
      31.135035,
      22.535244,
      NULL,
      19.542348,
      35.233802,
      19,
      NULL,
      7,
      29.822548,
      NULL,
      41.516100,
      NULL,
      87.226387,
      4.507128,
      50.918914,
      NULL,
      5,
      NULL,
      3,
      92,
      41,
      87,
      95.000618,
      195,
      153.165477,
      ' 0-21-1982',
      65,
      52,
      4,
      34,
      NULL,
      204.460275,
      '10-24-1998',
      NULL,
      2,
      0,
      0.139480,
      1.207029,
      5.582215,
      0,
      0,
      0,
      0,
      NULL,
      1,
      0.126940,
      1,
      1.974871,
      0,
      3.767421,
      NULL,
      NULL,
      0.846666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      12.566292,
      10,
      0,
      8,
      4,
      NULL,
      ' 3-14-1995',
      0,
      1,
      148,
      NULL,
      1.058015,
      8.416610,
      1,
      0.024307,
      53,
      NULL,
      1.831433,
      NULL,
      ' 9-20-1986',
      49,
      115,
      5,
      50.133343,
      125,
      76,
      111.359191,
      49,
      41.109197,
      77,
      5.018470,
      29.391948,
      ' 1-24-1997',
      NULL,
      NULL,
      NULL,
      48.021066,
      2,
      156,
      0.988689,
      ' 7-23-1981',
      21.880917,
      1.410829,
      NULL,
      8,
      1,
      25.506693,
      14,
      19,
      0,
      1.793457,
      29.602661,
      1.674078,
      8.781538,
      0.540908,
      1,
      25,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-22-2003',
      5,
      2.879841,
      3.063484,
      ' 3- 2-1998',
      NULL,
      3.627450,
      NULL,
      44.667272,
      14.811259,
      NULL,
      4,
      ' 2- 9-1988',
      4,
      NULL,
      1.137142,
      20.847210,
      NULL,
      79,
      NULL,
      ' 9-25-1994',
      NULL,
      NULL,
      ' 2- 2-1988',
      1,
      7.085566,
      NULL,
      0,
      2,
      7.756012,
      '11- 2-1995',
      62,
      1.599511,
      39,
      NULL,
      1.548246,
      78,
      ' 1- 8-1985',
      5.177448,
      NULL,
      NULL,
      7,
      ' 4- 3-1995',
      NULL,
      1.589312,
      50,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


