set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9936906';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      '2',
      '4',
      '2',
      NULL,
      '3',
      '1',
      '2',
      '0',
      '0',
      '0',
      '0',
      '2',
      NULL,
      '3',
      '2',
      '3',
      '3',
      '0',
      '2',
      '2',
      '4',
      '2',
      '1',
      '',
      '2',
      NULL,
      '3',
      '3',
      '4',
      '1',
      NULL,
      '',
      '',
      '2',
      NULL,
      '3',
      '2',
      '3',
      NULL,
      '0',
      '3',
      '2',
      '2',
      '0',
      '343',
      '44321020',
      28.913360,
      61,
      NULL,
      1.362611,
      1,
      0,
      NULL,
      '402331',
      NULL,
      ' 9-13-1990',
      ' 3-28-2003',
      84,
      6.181021,
      NULL,
      1.896184,
      24.527599,
      11,
      16.973596,
      8.009555,
      5,
      7.144770,
      17,
      13.878957,
      21.948141,
      12,
      16,
      NULL,
      NULL,
      17,
      18,
      NULL,
      70,
      16,
      37.356965,
      NULL,
      NULL,
      42.231318,
      32,
      NULL,
      NULL,
      NULL,
      15.270015,
      ' 9- 8-1974',
      NULL,
      57,
      4,
      NULL,
      128.478444,
      214,
      '10- 5-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      13.084901,
      1,
      '10-23-1980',
      NULL,
      0,
      NULL,
      1.556225,
      1.068011,
      62.003101,
      0,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      ' 7-23-1976',
      58,
      9,
      34.229206,
      52.950616,
      NULL,
      68.317975,
      0.170767,
      61,
      24,
      41.391459,
      NULL,
      0,
      ' 7- 3-1982',
      3,
      19,
      18.223838,
      NULL,
      34,
      70.049564,
      NULL,
      NULL,
      3,
      13.342987,
      NULL,
      8,
      15.688866,
      NULL,
      0,
      NULL,
      2.333648,
      1.483905,
      7.860198,
      0.751032,
      24,
      1.531686,
      0,
      NULL,
      25.739237,
      2,
      1,
      1.517084,
      1.288232,
      ' 5- 6-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      150.918214,
      7.837651,
      ' 4-19-1983',
      NULL,
      NULL,
      NULL,
      33,
      ' 9-23-1991',
      40,
      ' 7-19-1987',
      NULL,
      10.919680,
      ' 5-14-1991',
      47,
      19.062915,
      ' 9-17-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      14.506063,
      ' 8-12-1997',
      22.061776,
      20,
      41.664741,
      NULL,
      1,
      35.737035,
      ' 6- 9-2003',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL);
commit;
end;
/


