set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cogbat';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8322808';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-01-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cogbat_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      '4222',
      NULL,
      '32234411',
      NULL,
      '24003002',
      '41230020',
      NULL,
      '01442303',
      '34204432',
      '44032111',
      '23021040',
      NULL,
      '43411021',
      '33333221',
      '01110211',
      NULL,
      '10121103',
      '02313031',
      NULL,
      '32331201',
      '23340343',
      NULL,
      '40230241',
      '44134321',
      NULL,
      '00220443',
      '02224103',
      '30312220',
      '21004204',
      '33224302',
      '43130332',
      '33021404',
      '13012130',
      '11241413',
      '22343431',
      '41040100',
      '24444140',
      '20213012',
      '23041424',
      '40242113',
      '00133434',
      '10333114',
      '01413300',
      '24010120',
      '32022244',
      '',
      '',
      NULL,
      NULL,
      '0310441',
      NULL,
      NULL,
      3,
      NULL,
      '424220',
      3.913792,
      ' 5-25-1990',
      NULL,
      56.544599,
      NULL,
      6.500163,
      14,
      11,
      1.666205,
      127,
      0,
      3,
      NULL,
      NULL,
      17.519176,
      18,
      3,
      10,
      9,
      21,
      5,
      86,
      19.149627,
      34.265620,
      1,
      NULL,
      16.113269,
      NULL,
      28,
      168,
      84,
      212,
      65.770064,
      140.417221,
      ' 9-24-1982',
      NULL,
      48.414002,
      1,
      30,
      197,
      NULL,
      ' 2-25-1978',
      5.489934,
      3.547699,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.440107,
      0,
      0.582379,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-29-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10- 4-1990',
      20.514121,
      14.811229,
      NULL,
      98.274347,
      NULL,
      97.539152,
      NULL,
      89.228748,
      NULL,
      55,
      74,
      36.502165,
      ' 1-11-1992',
      1,
      33.786849,
      NULL,
      31,
      66.636157,
      NULL,
      12,
      ' 0-20-1986',
      27.389969,
      10,
      NULL,
      5.937588,
      NULL,
      1.242728,
      8.810236,
      10,
      NULL,
      NULL,
      7.450771,
      NULL,
      38.060809,
      1,
      1,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-17-1978',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      29.043179,
      53.960031,
      43.514914,
      NULL,
      NULL,
      32,
      ' 3- 4-1974',
      2.438419,
      16,
      18.799714,
      25.532462,
      '10-16-2002',
      9.174970,
      1.077792,
      130,
      ' 0-13-1984',
      NULL,
      NULL,
      NULL,
      NULL,
      39.288575,
      45,
      NULL,
      NULL,
      34,
      0,
      NULL,
      2,
      18.662026,
      0.176211,
      NULL,
      NULL,
      1,
      15.732701,
      1,
      1.077711,
      34,
      1,
      0.679825,
      88,
      NULL,
      0,
      102,
      NULL,
      31,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      1.810456,
      1,
      1.710351,
      NULL,
      NULL,
      NULL,
      12.659123,
      NULL,
      NULL,
      NULL,
      2.574280,
      24,
      1,
      0,
      0,
      9,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      4.931917,
      14,
      2.538076,
      NULL,
      NULL,
      NULL,
      NULL,
      17.963658,
      0.627390,
      0,
      2.358390,
      0,
      1.447427,
      1,
      0,
      NULL,
      ' 5- 4-1974',
      ' 3-14-1974',
      NULL,
      ' 4-18-1988',
      ' 2-18-1991',
      NULL,
      ' 3-27-1994',
      NULL);
commit;
end;
/


